#ifndef STRUCTS_H
#define STRUCTS_H

#include <QHostAddress>
#include <QDateTime>

/*
 * common structs and inline functions
 */

struct sServer {
    QHostAddress ip;
    unsigned short port;
};

inline bool operator==(const sServer s1, const sServer s2)
{
    return ( s1.ip.isEqual(s2.ip) and
             s1.port == s2.port );
}

// udp beacon server
struct HeartBeat {
    qint64          time = QDateTime::currentSecsSinceEpoch();
    QHostAddress    address;
    unsigned short  port;
    QString         gamename;
    QString         secure;
    QString         protocol = "unknown";
    bool            firstBeacon = true;
    QString         data = "";
};

#endif // STRUCTS_H
