#include "syncscheduler.h"

SyncScheduler::SyncScheduler()
{
}

bool SyncScheduler::init(const sSettings &settings,
                         const QSharedPointer<GameInfo> &gameInfoDetails,
                         const QSharedPointer<DatabaseHandle> &databaseHandle,
                         const QSharedPointer<Logger> &log)
{
    this->_settings          = settings;
    this->_gameInfoDetails   = gameInfoDetails;
    this->_databaseHandle    = databaseHandle;
    this->_log               = log;

    // sync action per server
    connect(&_execTimer, &QTimer::timeout, this, &SyncScheduler::onSyncExec);

    // sync cycle
    connect(&_syncTimer, &QTimer::timeout, this, [this]
    {
        // reset sync scheduler (if previous syncer was still running, it will be reset)
        _index = 0;
        _execTimer.setInterval(_execTime_ms);
        _execTimer.start();
    });

    // scheduler ready for use
    _init = true;
    return _init;
}

bool SyncScheduler::scheduleSyncer()
{
    // require that .init() was completed first
    if (! _init)
    {
        return false;
    }

    // start the sync timer
    _syncTimer.start(_syncTime_ms);

    // complete startup
    _log->logEvent("info", QStringLiteral("sync with other masterservers every %1 minutes")
                            .arg(QString::number(_syncTime_ms/60000)));
    return true;
}

void SyncScheduler::onSyncExec()
{
    // next serverlist item (or reset)
    if ( _index >= _settings.Syncer.syncServers.length() - 1 )
    {
        // last item to be completed
        _execTimer.stop();
    }

    _log->logEvent("debug", QStringLiteral("syncing with #%1").arg(QString::number(_index)));

    // synchronise with master
    new SyncClient( _settings,
                   _gameInfoDetails,
                   _databaseHandle,
                   _log,
                   _settings.Syncer.syncServers.value(_index).remoteAddress,
                   _settings.Syncer.syncServers.value(_index).listenPort );

    // next cycle next address
    _index++;
}
