#ifndef SYNCSCHEDULER_H
#define SYNCSCHEDULER_H

#include <QTimer>

#include "Settings/structsettings.h"
#include "Games/gameinfo.h"
#include "Logger/logger.h"
#include "Database/databasehandle.h"
#include "TcpTasks/syncclient.h"

class SyncScheduler: public QObject
{
    Q_OBJECT
public:
    SyncScheduler();
    bool init(const sSettings                      &settings,
              const QSharedPointer<GameInfo>       &gameInfoDetails,
              const QSharedPointer<DatabaseHandle> &databaseHandle,
              const QSharedPointer<Logger>         &log);
    bool scheduleSyncer();

private:
    // helpers
    bool _init = false;
    int  _index = 0;

    // interfaces
    sSettings                       _settings;
    QSharedPointer<GameInfo>        _gameInfoDetails;
    QSharedPointer<DatabaseHandle>  _databaseHandle;
    QSharedPointer<Logger>          _log;

    // schedule timer
    QTimer _syncTimer;
    QTimer _execTimer;

    // settings
    int _syncTime_ms = 30 * 60 * 1000; // every half hour
    int _execTime_ms = 1000; // 1s interval per sync

signals:

private slots:
    void onSyncExec();


};

#endif // SYNCSCHEDULER_H
