#ifndef VERSION_H
#define VERSION_H

#include <QString>

/*
 * Version and author information
 *
 * Only when you make (significant) modifications to the master server source
 * code, you should edit these variables to reflect your changes.
 *
 * For example,
 * if you limit functionality to only one game, you should change the variable
 * BUILD_TYPE and SHORT_VER to something that reflects the change in function.
 *
 * In addition, if you have the actual interest to go through all this source
 * code to end up here, consider sending Darkelarious (the original author) a
 * postcard or (e)mail with your compliments. Or buy us a coffee. We like the
 * appreciation.
 */

// gamename for the 333networks-type MasterServer
const QString TYPE_GAMENAME = "333networks";

// build type: type of software
const QString BUILD_TYPE = "MasterServer Qt5";

// software version (of this particular type)
const QString BUILD_VERSION  = "0.11";

// build time/date
const QString BUILD_TIME = QString("%1 %2").arg(__DATE__).arg(__TIME__);

 // software author, contact
const QString BUILD_AUTHOR = "Darkelarious <darkelarious@333networks.com>";

// short version (in query)
const QString SHORT_VER = "Qt-" + BUILD_VERSION; // Qt5 v0.n

// is this a debugging version?
const bool DEBUG = true;

#endif // VERSION_H
