#ifndef DATABASEHANDLE_H
#define DATABASEHANDLE_H

#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
#include <QDataStream>
#include <QDateTime>
#include <QHostAddress>

#include "Settings/structsettings.h"
#include "Logger/logprimitive.h"
#include "Core/version.h"
#include "Core/structs.h"

class DatabaseHandle
{
public:
    DatabaseHandle();
    bool init(const sSettings &settings,
              const QString   &applicationPath);
    void close();

    // insert, update or delete a server from the list
    bool insertServer(const QHostAddress    &serverAddress,
                      const unsigned short  &serverPort,
                      const QString         &gamename,
                      const bool            &directBeacon);

    bool updateServer(const QHostAddress    &serverAddress,
                      const unsigned short  &serverPort,
                      const QString         &gamename,
                      const bool            &directBeacon);

    // get processed serverlist
    QByteArray compileServerlist(const QString  &gamename,
                                 const int      &serverAge_s,
                                 const bool     &cmp,
                                 const bool     &setIPv6);

    // get processed synclist
    QByteArray compileSyncList(const QStringList &gamenameList,
                               const int         &serverAge_s,
                               const bool        &setIPv6);

    // get list of active gamenames
    QStringList getGamenames(const int &serverAge_s);

    // get list of active masterservers (uplink and sync)
    QList<sServer> getUplinkList(const int &serverAge_s);

    // get server with the next index in line
    QHash<QString, QString> getNextServer(const int &index,
                                          const int &serverAge_s);

private:
    // create the necessary tables
    bool createTables(const QString &type);

    // report execution errors (terminal/display only)
    bool reportQuery(const QSqlQuery &q); // always returns false!

    // select queries
    QSqlQuery selectGamenameList(const int &serverAge_s);
    QSqlQuery selectServerList(const QString &gamename,
                               const int &serverAge_s);
    QSqlQuery selectNextServerById(const int &index,
                                   const int &serverAge_s);


private:
    // path to SQLite database location
    QString _sqlitePath = "../data/masterserver.db";

    // dbi handle
    QSqlDatabase _dbi;
};

#endif // DATABASEHANDLE_H
