#include "databasehandle.h"

bool DatabaseHandle::createTables(const QString &type)
{
    // every database type naturally has its own definition for date/time. Parse.
    const QHash<QString, QString> dateTimeText {
        {"QSQLITE", "(CAST(strftime('%s','now') AS BIGINT))"},
        {"QMYSQL",  "UNIX_TIMESTAMP()"},
        {"QPSQL",   "(EXTRACT(epoch FROM NOW()))"}
    };

    const QHash<QString, QString> indexCol {
        {"QSQLITE", "INTEGER PRIMARY KEY AUTOINCREMENT"},
        {"QMYSQL",  "INTEGER NOT NULL AUTO_INCREMENT"},
        {"QPSQL",   "SERIAL UNIQUE NOT NULL PRIMARY KEY"}
    };

    // create query
    QSqlQuery q;
    QString createServerlist = QStringLiteral(
        "CREATE TABLE serverlist("
        "id            %2,"
        "gamename      TEXT      NOT NULL DEFAULT '',"
        "ip            TEXT      NOT NULL ,"
        "port          INTEGER   NOT NULL ,"
        "directbeacon  INTEGER   NOT NULL DEFAULT 0,"
        "blacklisted   INTEGER   NOT NULL DEFAULT 0,"
        "dt_added      BIGINT    NOT NULL DEFAULT %1,"
        "dt_beacon     BIGINT    NOT NULL DEFAULT %1,"
        "dt_updated    BIGINT    NOT NULL DEFAULT %1"
        ")").arg( dateTimeText.value(type , "0"), indexCol.value(type, "INTEGER NOT NULL DEFAULT 0") );

    // bind values and execute
    // * note: postgresql does not support prepare(create table), thus q.exec(query).
    if ( ! q.exec(createServerlist) )
        return reportQuery(q);

    // no errors
    return true;
}
