#include "databasehandle.h"

QHash<QString, QString> DatabaseHandle::getNextServer(const int &index,
                                          const int &serverAge_s)
{
    // get next server
    QSqlQuery q = selectNextServerById(index, serverAge_s);

    // result list
    QHash<QString, QString> nextServer;

    // only return the first element
    if ( q.next() )
    {
        nextServer.insert("id",       q.value("id").toString() );
        nextServer.insert("ip",       q.value("ip").toString() );
        nextServer.insert("port",     q.value("port").toString() );
        nextServer.insert("gamename", q.value("gamename").toString() );
    }

    // done
    return nextServer;
}
