#include "databasehandle.h"

QList<sServer> DatabaseHandle::getUplinkList(const int &serverAge_s)
{
    // retrieve servers from database
    QSqlQuery q = selectServerList( TYPE_GAMENAME, serverAge_s);

    // list with ip addresses of 333networks masterservers
    QList<sServer> masterList;

    // iterate through resulting queries and add to compile list
    while (q.next())
    {
        sServer master;
        master.ip   = QHostAddress( q.value(0).toString() );
        master.port = q.value(1).value<unsigned short>();
        masterList.append(master);
    }
    return masterList;
}
