#include "databasehandle.h"

bool DatabaseHandle::init(const sSettings &settings,
                          const QString &applicationPath)
{
    // db type
    QString type = settings.Database.databaseType.toUpper();

    // sanity check
    if ( type.isEmpty() )
    {
        logPrimitive() << "Empty SQL type setting." << endl;
        return false;
    }

    // only sqlite uses the database file, rest uses login
    _dbi = QSqlDatabase::addDatabase( type );
    if ( ! _dbi.isValid() )
    {
        logPrimitive() << "Invalid SQL type setting provided." << endl;
        return false;
    }

    if ( type == "QSQLITE" )
    {
        // generates if not available
        _dbi.setDatabaseName(applicationPath+"/" + _sqlitePath);
    }
    else
    {
        _dbi.setDatabaseName(settings.Database.dbname);
        _dbi.setUserName(    settings.Database.user);
        _dbi.setPassword(    settings.Database.pass);
        // mysql: setPort()
        // opt:   setConnectOptions()
    }

    // open database
    if ( ! _dbi.open() )
    {
        QSqlError sqlError = _dbi.lastError();
        logPrimitive() << "Error opening database: " << sqlError.text() << endl;
        return false;
    }

    if ( _dbi.tables().contains("serverlist") )
    {
        // success.
        return true;
    }

    // relevant tables do not exist. ask to generate.
    logPrimitive() << "The database table(s) do not exist. Do you want to generate these? [y/N]" << endl;

    // if no, do not proceed.
    if ( ! QTextStream(stdin).readLine().startsWith("y") )
    {
        // do not generate. failed to load database.
        return false;
    }

    // create tables and proceed
    return createTables( type );
}
