#include "databasehandle.h"

QSqlQuery DatabaseHandle::selectGamenameList(const int &serverAge_s)
{
    QSqlQuery q;
    QString selectString = "SELECT DISTINCT gamename FROM serverlist "
                           "WHERE dt_updated > :timestamp "
                           "ORDER BY gamename ASC";

    // bind and execute
    q.prepare(selectString);
    q.bindValue(":timestamp", QDateTime::currentDateTime().addSecs(-serverAge_s ).toSecsSinceEpoch());
    if ( ! q.exec() ) reportQuery(q);

    return q;
}

QSqlQuery DatabaseHandle::selectServerList(const QString &gamename,
                                           const int &serverAge_s)
{
    // retrieve servers from database
    QSqlQuery q;
    QString selectString = "SELECT ip, port FROM serverlist "
                           "WHERE gamename = :gamename "
                           "AND dt_updated > :timestamp ";

    // bind values and execute
    q.prepare(selectString);
    q.bindValue(":gamename", gamename);
    q.bindValue(":timestamp", QDateTime::currentDateTime().addSecs(-serverAge_s ).toSecsSinceEpoch());
    if ( ! q.exec() )
        reportQuery(q);

    return q;
}

QSqlQuery DatabaseHandle::selectNextServerById(const int &index,
                                               const int &serverAge_s)
{
    // retrieve servers from database
    QSqlQuery q;
    QString selectString = "SELECT id, ip, port, gamename FROM serverlist "
                           "WHERE id > :id "
                           "AND dt_updated > :timestamp "
                           "ORDER BY id ASC "
                           "LIMIT 1 ";

    // bind values and execute
    q.prepare(selectString);
    q.bindValue(":id", index);
    q.bindValue(":timestamp", QDateTime::currentDateTime().addSecs(-serverAge_s ).toSecsSinceEpoch());
    if ( ! q.exec() )
        reportQuery(q);

    return q;
}
