#include "databasehandle.h"

bool DatabaseHandle::updateServer(const QHostAddress &serverAddress,
                                  const unsigned short &serverPort,
                                  const QString &gamename,
                                  const bool &directBeacon)
{
    // update existing entry, but do not insert.
    QSqlQuery q;
    QString updateString;

    // direct beacon?
    if (directBeacon)
    {
        // update directbeacon, dt_beacon, dt_updated
        updateString = "UPDATE serverlist SET "
                               "directbeacon = 1, "
                               "dt_beacon    = :timestamp, "
                               "dt_updated   = :timestamp "
                        "WHERE ip = :ip AND port = :port AND gamename = :gamename ";
    }
    else
    {
        // update dt_updated
        updateString = "UPDATE serverlist SET "
                               "dt_updated   = CURRENT_TIMESTAMP"
                        "WHERE ip = :ip AND port = :port AND gamename = :gamename";
    }

    // bind values and execute
    q.prepare(updateString);
    q.bindValue(":timestamp", QDateTime::currentSecsSinceEpoch() );
    q.bindValue(":ip", serverAddress.toString());
    q.bindValue(":port", serverPort);
    q.bindValue(":gamename", gamename);

    if ( ! q.exec() )
        return reportQuery(q);

    // was a row updated?
    return (q.numRowsAffected() > 0);
}
