#include "Logger/logger.h"

/**
 * @brief Log cycling from Settings.
 * If "now" matches the previous logfile name, ignore the cycle
 * command. If "now" is different from "before", close the log
 * file and open a new logfile.
 * @return false if the new file could not be opened.
 */
bool Logger::cycleLogFile()
{
    // calculate the expected log filename
    QString newFilename = this->_logLabel;

    // get date to see if we need to cycle
    QDate date(QDate::currentDate());

    // when is it necessary to cycle?
    switch ( _cycle )
    {
        case yearly:
            newFilename += date.toString("-yyyy");
            break;
        case monthly:
            newFilename += date.toString("-yyyy-MM");
            break;
        case weekly:
            newFilename += date.toString("-yyyy") + "-week" + QString("%1").arg(date.weekNumber(), 2, 10, QChar('0'));
            break;
        case daily:
            newFilename += date.toString("-yyyy-MM-dd");
            break;
        default:; // 0 = never
    }

    // and add extension
    newFilename += ".log";

    // if current and new filename are not the same, cycle log file
    if (this->_logFileName != newFilename)
    {
        // cycle log file
        this->_logFileName = newFilename;

        // close the existing/opened log file
        closeLogFile();

        // open the new log file (pass possible error to caller)
        return openLogFile();
    }

    // else: no cycling necessary
    return true;
}
