#include "logger.h"

/**
 * @brief write a message directly to the log. appends date/timestamp.
 * @param message to be written to the log
 * @returns false if writing failed
 */
bool Logger::writeLogFile(const QString message)
{
    // first see if we need to cycle the log file already
    cycleLogFile();

    // write to file
    if ( _logFile.isOpen() )
    {
        QTextStream logStream(&_logFile);
        logStream << message << endl;
        return true;
    }

    // in case of errors, let caller report        return false;
    return false;
}
