#include "securevalidate.h"

AuthResult validateGamename(const ClientType &clientType,
                            const QString &gamename,
                            const QString &validate,
                            const QString &cipherIn,
                            const QString &secureIn,
                            const int     &enctypeIn)
{
    // output result
    AuthResult authResult;

    // inputs + checks
    QByteArray secure = secureIn.toUtf8();
    QByteArray cipher = cipherIn.toUtf8();
    unsigned char cipherLength = static_cast<unsigned char>( cipher.length() );
    unsigned char secureLength = static_cast<unsigned char>( secure.length() );

    // length checks
    if ( 6 <= cipherLength and cipherLength < 16 and
         6 <= secureLength and secureLength < 16 )
    {
        // safe to call validation. proceed.
        authResult.validate = generateValidateString(cipher, secure, enctypeIn);
    }
    else
    {
        // incorrect input, not safe to calculate validation
        authResult.auth = false;
        authResult.validate = "invalid!";
    }

    // correct validation provided?
    authResult.auth = (authResult.validate.compare(validate) == 0);

    // override certain cases
    if ( clientType == BEACON and _overrideValidateBeacon.contains(gamename) )
        authResult.auth = true;

    // override certain cases
    if ( clientType == CLIENT and _overrideValidateClient.contains(gamename) )
        authResult.auth = true;

    // return result as boolean and string
    return authResult;
}

QString genChallengeString(const int len, const bool moreChars)
{
    QString randomString;
    if (moreChars)
    {
        // use A-Za-z0-9
        for(unsigned char i = 0; i < len; ++i)
        {
            randomString += moreCharacters[qrand() % moreCharacters.length()];
        }
    }
    else
    {
        // use A-Z only
        for(unsigned char i = 0; i < len; ++i)
        {
            randomString += possibleCharacters[qrand() % possibleCharacters.length()];
        }
    }
    return randomString;
}
