#include "settings.h"

void Settings::writeSettings()
{
    // user already specified that config is to be written
    QSettings settingsFile(_applicationPath+"/"+_settingsPath, QSettings::IniFormat);

    // public details
    settingsFile.setValue("PublicDetails/Hostname",  settings.PublicInformation.hostname);
    settingsFile.setValue("PublicDetails/AdminName", settings.PublicInformation.adminName);
    settingsFile.setValue("PublicDetails/Contact",   settings.PublicInformation.contact);

    // network settings
    settingsFile.setValue("Network/BeaconPort",             settings.Network.beaconPort);
    settingsFile.setValue("Network/ListenPort",             settings.Network.listenPort);
    settingsFile.setValue("Network/ServerLifeTimeSeconds",  settings.Network.serverttl_s);
    settingsFile.setValue("Network/AllowLocal",             settings.Network.allowLocal);

    // sync settings
    settingsFile.setValue("Syncer/DoUplink",  settings.Syncer.doUplink);
    settingsFile.setValue("Syncer/DoSync",    settings.Syncer.doSync);
    settingsFile.setValue("Syncer/SyncGames", settings.Syncer.syncGames);

    // if uplink is set, but no servers are listed, generate default line with 333networks
    if ( settings.Syncer.doUplink and settings.Syncer.syncServers.size() <= 0 )
    {
        sSyncServer defaultServer;
        defaultServer.remoteAddress = "master.333networks.com"; // default settings are correct
        settings.Syncer.syncServers.append(defaultServer);
    }

    // write list of servers
    QListIterator<sSyncServer> syncRecordIterator(settings.Syncer.syncServers);
    int i = 0;

    settingsFile.beginWriteArray("Syncer");
    while ( syncRecordIterator.hasNext() )
    {
        // next list item
        sSyncServer syncServer = syncRecordIterator.next();
        if ( syncServer.remoteAddress.size() > 0 )
        {
            // write to settings file
            settingsFile.setArrayIndex(i++);

            // output format 1\SyncServer=master.333networks.com, 27900, 28900, all
            QString strServer = QStringLiteral("%1, %2, %3")
                    .arg(syncServer.remoteAddress,
                         QString::number(syncServer.beaconPort),
                         QString::number(syncServer.listenPort) );
            settingsFile.setValue("SyncServer", strServer);
        }

    }
    settingsFile.endArray();

    // database settings
    settingsFile.setValue("Database/Type",          settings.Database.databaseType.toUpper()); // consistent with manual
    settingsFile.setValue("Database/DatabaseName",  settings.Database.dbname);
    settingsFile.setValue("Database/Username",      settings.Database.user);
    settingsFile.setValue("Database/Password",      settings.Database.pass);

    // logging settings
    settingsFile.setValue("Logging/CycleLogs",      settings.Logging.cycle);
    settingsFile.setValue("Logging/SuppressLog",    settings.Logging.suppressLog);
    settingsFile.setValue("Logging/SuppressDisplay",settings.Logging.suppressDisplay);
}
