#include "listenserver.h"

ListenServer::ListenServer()
{
    connect(&_tcpServer, &QTcpServer::newConnection, this, &ListenServer::onTcpConnection);
}

bool ListenServer::listen(const sSettings &settings,
                          const QSharedPointer<GameInfo> &gameInfoDetails,
                          const QSharedPointer<DatabaseHandle> &databaseHandle,
                          const QSharedPointer<Logger> &log)
{
    // load settings
    this->_serverttl_s          = settings.Network.serverttl_s;
    this->_masterserverIdentity = settings.masterserverIdentity;

    this->_gameInfoDetails   = gameInfoDetails;
    this->_databaseHandle    = databaseHandle;
    this->_log               = log;

    // start listening
    bool e = _tcpServer.listen(QHostAddress::Any, settings.Network.listenPort);

    // error notification:
    if ( !e )
    {
        // fatal error
        log->logEvent("fatal", QStringLiteral("error starting tcp Listen server: %1")
                      .arg(_tcpServer.errorString()));
        return false;
    }

    // complete startup
    log->logEvent("info", QStringLiteral("start listening for TCP beacons on port %1")
                            .arg(settings.Network.listenPort));
    return true;
}

void ListenServer::onTcpConnection()
{
    new TcpClient( _tcpServer.nextPendingConnection(),
                   _serverttl_s,
                   _masterserverIdentity,
                   _gameInfoDetails,
                   _databaseHandle,
                   _log );
}
