#include "syncclient.h"

QStringList SyncClient::replyQuery(const QMultiHash<QString,  QString> &query)
{
    // initialise output
    QStringList queryResponse;

    // gamespy uses incrementing query ids in the messages
    queryId = ( (queryId > 99) ? 1 : queryId + 1 );
    int querySubId = 1;

    // secure response
    if ( query.contains("secure") and _gameInfoDetails->supportedGames.contains(TYPE_GAMENAME))
    {
        // sanity checks
        QByteArray secure = query.value("secure", "").toUtf8();
        QByteArray cipher = _gameInfoDetails->supportedGames.value(TYPE_GAMENAME).cipher.toUtf8();
        int enctype = query.value("enctype", "0").toInt();
        QString validate;

        // get validate value
        if ( 6 <= cipher.length() and cipher.length() < 16 and
             6 <= secure.length() and secure.length() < 16 )
        {
            validate = generateValidateString(cipher, secure, enctype);
        }
        else
        {
            validate = "invalid!";
        }
        queryResponse.append(
                    QStringLiteral("\\validate\\%1\\queryid\\%2.%3")
                        .arg(validate, QString::number(queryId), QString::number(querySubId++))
                );
    }

    // basic
    if ( query.contains("basic") )
    {
        queryResponse.append(
                    QStringLiteral("\\gamename\\%1"
                                   "\\gamever\\%2"
                                   "\\location\\0"
                                   "\\queryid\\%3.%4")
                        .arg(TYPE_GAMENAME, SHORT_VER, QString::number(queryId), QString::number(querySubId++))
                );
    }



    // end query with final
    queryResponse.append("\\final\\");

    return queryResponse;
}
