#ifndef SYNCCLIENT_H
#define SYNCCLIENT_H

#include <QTimer>
#include <QTcpSocket>
#include <QHostAddress>

#include "Games/gameinfo.h"
#include "Logger/logger.h"
#include "Database/databasehandle.h"
#include "Protocols/GameSpy0/gamespy0.h"
#include "Protocols/GameSpy0/securevalidate.h"

class SyncClient: public QObject
{
    Q_OBJECT
public:
    SyncClient(const sSettings settings,
               const QSharedPointer<GameInfo>        &gameInfoDetails,
               const QSharedPointer<DatabaseHandle>  &databaseHandle,
               const QSharedPointer<Logger>          &log,
               const QHostAddress remoteAddress,
               unsigned short remotePort);
    SyncClient(const sSettings settings,
               const QSharedPointer<GameInfo>        &gameInfoDetails,
               const QSharedPointer<DatabaseHandle>  &databaseHandle,
               const QSharedPointer<Logger>          &log,
               const QString remoteAddress,
               unsigned short remotePort);

private:

    // interfaces
    sSettings                       _settings;
    QSharedPointer<GameInfo>        _gameInfoDetails;
    QSharedPointer<DatabaseHandle>  _databaseHandle;
    QSharedPointer<Logger>          _log;

    // tcp client handles
    QTcpSocket _tcpSocket;
    QTimer     _timeOut;
    QByteArray _rxBuffer = "";
    QString    _clientLabel;

    // internal setting
    int _timeOutTime_ms = 5000;

    // secure/validate challenge
    int queryId = 0;
    QStringList replyQuery(const QMultiHash<QString, QString> &query);


private slots:
    void onConnect();
    void onRead();
    void onDisconnect();
    void onTimeOut();

};

#endif // SYNCCLIENT_H
