#include "tcpclient.h"

TcpClient::TcpClient(QTcpSocket *tcpSocket,
                     const int &serverttl_s,
                     const QString &masterserverIdentity,
                     const QSharedPointer<GameInfo> &gameInfoDetails,
                     const QSharedPointer<DatabaseHandle> &databaseHandle,
                     const QSharedPointer<Logger> &log)
    : _tcpSocket(tcpSocket)
{
    // connect events and functions
    connect(tcpSocket, &QTcpSocket::readyRead,    this, &TcpClient::onRead);
    connect(tcpSocket, &QTcpSocket::disconnected, this, &TcpClient::onDisconnect);
    connect(&_timeOut, &QTimer::timeout,          this, &TcpClient::onTimeOut);

    // pass interfaces
    this->_gameInfoDetails   = gameInfoDetails;
    this->_databaseHandle    = databaseHandle;
    this->_log               = log;

    // beacon lifetime setting
    this->_serverttl_s = serverttl_s;

    // masterserver identifier
    this->_masterserverIdentity = masterserverIdentity;

    // timeout
    _timeOut.setInterval( _timeOutTime_ms );
    _timeOut.start();

    // challenge client
    _clientLabel = QStringLiteral("%1:%2").arg(tcpSocket->peerAddress().toString(), QString::number(tcpSocket->peerPort()));
    _secure      = genChallengeString(6, false);
    _tcpSocket->write( QStringLiteral("\\basic\\\\secure\\%1").arg(_secure).toUtf8() );
    _tcpSocket->flush();

    // log
    _log->logEvent("tcp", QStringLiteral("%1 connected").arg(_clientLabel) );
}

void TcpClient::disconnect()
{
    _timeOut.stop();
    _tcpSocket->disconnectFromHost();
}

void TcpClient::onDisconnect()
{
    _timeOut.stop();
    _log->logEvent("tcp", QStringLiteral("%1 disconnected").arg(_clientLabel) );
    this->deleteLater();
}

void TcpClient::onTimeOut()
{
    _log->logEvent("tcp", QStringLiteral("%1 timed out").arg(_clientLabel) );
    this->disconnect();
}
