#ifndef TCPCLIENT_H
#define TCPCLIENT_H

#include <QTimer>
#include <QTcpSocket>
#include <QHostAddress>

#include "Games/gameinfo.h"
#include "Logger/logger.h"
#include "Database/databasehandle.h"
#include "Protocols/GameSpy0/gamespy0.h"
#include "Protocols/GameSpy0/securevalidate.h"

class TcpClient : public QObject
{
    Q_OBJECT
public:
    TcpClient(QTcpSocket *tcpSocket,
              const int                             &serverttl_s,
              const QString                         &masterserverIdentity,
              const QSharedPointer<GameInfo>        &gameInfoDetails,
              const QSharedPointer<DatabaseHandle>  &databaseHandle,
              const QSharedPointer<Logger>          &log);

private:
    // tcp client handles
    QScopedPointer<QTcpSocket>  _tcpSocket;
    QTimer                      _timeOut;
    QByteArray                  _rxBuffer = "";
    bool                        _hasValidated = false;

    QString _clientLabel;
    QString _secure;

    // internal setting
    int _timeOutTime_ms = 5000;
    int _serverttl_s;
    QString _masterserverIdentity;

    // interfaces
    QSharedPointer<GameInfo>        _gameInfoDetails;
    QSharedPointer<DatabaseHandle>  _databaseHandle;
    QSharedPointer<Logger>          _log;

private:
    void disconnect();

private slots:
    void onRead();
    void onTimeOut();
    void onDisconnect();

};

#endif // TCPCLIENT_H
