#include "beaconserver.h"

// helper variable for serverqueries
int queryId = 0;

QStringList BeaconServer::replyQuery(const QMultiHash<QString, QString> &query)
{
    // initialise output
    QStringList queryResponse;

    // gamespy uses incrementing query ids in the messages
    queryId = ( (queryId > 99) ? 1 : queryId + 1 );
    int querySubId = 1;

    // secure response
    if ( query.contains("secure") and _gameInfoDetails->supportedGames.contains(TYPE_GAMENAME))
    {
        // sanity checks
        QByteArray secure = query.value("secure", "").toUtf8();
        QByteArray cipher = _gameInfoDetails->supportedGames.value(TYPE_GAMENAME).cipher.toUtf8();
        int enctype = query.value("enctype", "0").toInt();
        QString validate;

        // get validate value
        if ( 6 <= cipher.length() and cipher.length() < 16 and
             6 <= secure.length() and secure.length() < 16 )
        {
            validate = generateValidateString(cipher, secure, enctype);
        }
        else
        {
            validate = "invalid!";
        }
        queryResponse.append(
                    QStringLiteral("\\validate\\%1\\queryid\\%2.%3")
                        .arg(validate, QString::number(queryId), QString::number(querySubId++))
                );
    }

    // basic
    if ( query.contains("basic") or query.contains("status") )
    {
        queryResponse.append(
                    QStringLiteral("\\gamename\\%1"
                                   "\\gamever\\%2"
                                   "\\location\\0"
                                   "\\queryid\\%3.%4")
                        .arg(TYPE_GAMENAME, SHORT_VER, QString::number(queryId), QString::number(querySubId++))
                );
    }

    // info
    if ( query.contains("info") or query.contains("status") )
    {
        // cast server statistics as player info
        int numGames = 0; // TODO: implement getting this info from the database
        int maxGames = _gameInfoDetails->supportedGames.size();

        queryResponse.append(
                    QStringLiteral("\\hostname\\%1"
                                   "\\hostport\\%2"
                                   "\\gametype\\%3"
                                   "\\mapname\\333networks"
                                   "\\numplayers\\%4"
                                   "\\maxplayers\\%5"
                                   "\\gamemode\\openplaying"
                                   "\\queryid\\%6.%7")
                        .arg( _settings.PublicInformation.hostname,
                              QString::number(_settings.Network.listenPort),
                              "masterserver",   // replace for "bare masterserver" or "integrated beacon/website checker"
                              QString::number(numGames),
                              QString::number(maxGames),
                              QString::number(queryId), QString::number(querySubId++))
                );
    }

    // rules
    if ( query.contains("rules") or query.contains("status") )
    {
        // compile information about the specific software
        QString mutators;
        mutators.append( QStringLiteral("buildtype: %1, buildtime: %2, debug: %3, author: %4")
                         .arg(BUILD_TYPE, BUILD_TIME, (DEBUG ? "true" : "false"), BUILD_AUTHOR) );

        queryResponse.append(
                    QStringLiteral("\\mutators\\%1"
                                   "\\AdminName\\%2"
                                   "\\AdminEMail\\%3"
                                   "\\queryid\\%4.%5")
                        .arg( mutators,
                              _settings.PublicInformation.adminName,
                              _settings.PublicInformation.contact,
                              QString::number(queryId), QString::number(querySubId++))
                );
    }

    // echo: reply with echo_reply
    if (query.contains("echo"))
    {
        queryResponse.append(QStringLiteral("\\echo_reply\\%1\\queryid\\%2.%3")
                             .arg(query.value("echo"), QString::number(queryId), QString::number(querySubId++))
                );
    }

    // end query with final
    queryResponse.append("\\final\\");

    return queryResponse;
}
