#include "beaconserver.h"

bool BeaconServer::listen()
{
    // require that .init() was completed first
    if (! _init)
    {
        return false;
    }

    // connect socket, timer with events
    connect(&_udpSocket, &QUdpSocket::readyRead, this, &BeaconServer::onUdpRead);
    connect(&_sweepTimer, &QTimer::timeout, this, &BeaconServer::onUdpTimedOut);

    // bind socket and timeout
    _udpSocket.bind(QHostAddress::Any, _settings.Network.beaconPort);
    _sweepTimer.start( _timeOutTime_ms );

    // complete startup
    _log->logEvent("info", QStringLiteral("start listening for UDP beacons on port %1")
                            .arg(_settings.Network.beaconPort));

    return true;
}
