#include "beaconserver.h"

bool BeaconServer::uplink()
{
    // require that .init() was completed first
    if (! _init)
    {
        return false;
    }

    // return "success" if this function is disabled by setting
    if (! _settings.Syncer.doUplink )
    {
        return true;
    }

    // connect socket, timer with events
    connect(&_resolveTimer, &QTimer::timeout, this, &BeaconServer::onResolveTimer);
    connect(&_heartbeatTimer, &QTimer::timeout, this, &BeaconServer::onHeartbeatTimer);

    // start timers
    _resolveTimer.start(_resolveInterval);
    _heartbeatTimer.start( _broadcastInterval );

    // resolve all provided addresses right away
    this->onResolveTimer();

    // create heartbeat
    _heartbeatData = QStringLiteral("\\heartbeat\\%1\\gamename\\%2\\final\\")
            .arg( QString::number(_settings.Network.beaconPort), TYPE_GAMENAME );

    // complete startup
    _log->logEvent("info", QStringLiteral("broadcasting udp uplinks every %1 seconds")
                            .arg( _broadcastInterval / 1000.0 ));

    return true;
}
