#include "commonactions.h"

bool updateServer(const QHostAddress    &serverAddress,
                  const unsigned short  &serverPort,
                  const bool            &directBeacon,
                  const bool            &authenticated
                  )
{
    // update existing entry, but do not insert.
    QSqlQuery q;
    QString updateString;

    // update with available values
    updateString = "UPDATE serverlist SET ";

    /*
     * Note that direct/auth set to 'false' will NOT override a previous value in the database
     */

    // is this a direct beacon?
    if (directBeacon)
    {
        updateString += "f_direct = 1, ";
        updateString += "dt_beacon  = :timestamp, ";
    }

    // did the server authenticate?
    if (authenticated) updateString += "f_auth   = 1, ";

    updateString +=  "dt_updated = :timestamp "
                     "WHERE ip = :ip AND queryport = :queryport";

    // bind values and execute
    q.prepare(updateString);
    q.bindValue(":ip", serverAddress.toString());
    q.bindValue(":queryport", serverPort);
    q.bindValue(":timestamp", QDateTime::currentSecsSinceEpoch() );

    if ( ! q.exec() )
        return reportQuery(q);

    // was a row updated?
    return (q.numRowsAffected() > 0);
}
