#include "statuschecker.h"

void StatusChecker::onUdpResponseRead()
{
    // read now called, reset workaround counter
    _missedReadCalls = 0;

    while ( _udpSocket.hasPendingDatagrams() )
    {
        // get sender and payload
        QNetworkDatagram    datagram        = _udpSocket.receiveDatagram();
        QHostAddress        senderAddress   = QHostAddress( datagram.senderAddress().toIPv6Address() );
        unsigned short      senderPort      = datagram.senderPort();
        QString             receiveBuffer   = datagram.data();

        // shorthand label
        QString senderAddressLabel = QStringLiteral("%1:%2").arg(senderAddress.toString(), QString::number(senderPort));

        // FIXME: where to put the .toLatin1()
        _coreObject->Log.logEvent("udp", QStringLiteral("%1 sent '%2'")
                           .arg(senderAddressLabel, receiveBuffer ) );

        // apparently it is possible to receive empty data packets. ignore them for now (happens when a query port is forwarded to a game port)
        // log for debugging purposes
        if (receiveBuffer.length() <= 0)
        {
            _coreObject->Log.logEvent("udp", QStringLiteral("received empty packet from %1")
                           .arg(senderAddressLabel));
            continue;
        }

        // determine protocol and response based on the first character (backslash, byte value, ... )
        // assume GameSpy v0 protocol used by Unreal/UT, Postal2, Rune, DeusEx among others
        // -- other games should not respond to status
        unsigned short protocol_chooser = receiveBuffer.at(0).unicode();
        if (protocol_chooser != 92)
            continue;

        // buffer complete? else wait for data to be complete
        _dataBuffer[senderAddressLabel] += receiveBuffer.toLatin1();
        if (! receiveBuffer.contains("\\final\\"))
            continue;

        // parse key/value pairs and QHash label
        QMultiHash<QString, QString> receiveData = parseGameSpy0Buffer(_dataBuffer[senderAddressLabel]);

        // update or insert primary details
        if ( ! updateServer(senderAddress, senderPort, false, false) )
        {
            // add to database
            insertServer(senderAddress, senderPort, receiveData.value("gamename", "unknown"), false);

            // log inserts
            _coreObject->Log.logEvent("new", QStringLiteral("checker insert %1 for %2")
                           .arg(senderAddressLabel, receiveData.value("gamename", "unknown")) );
        }
        else
        {
            // log updates
            _coreObject->Log.logEvent("check", QStringLiteral("update %1 for %2")
                           .arg(senderAddressLabel, receiveData.value("gamename", "unknown")) );
        }

        // then update detailed information
        if ( ! updateServerInfo(senderAddress, senderPort, receiveData) )
        {
            // insert and update new entry (this does NOT insert to the serverlist, only info)
            // this assumes that an entry with this ip/port exists in the serverlist (fails silently)
            insertServerInfo(senderAddress, senderPort);
            updateServerInfo(senderAddress, senderPort, receiveData);
        }

        // update player info (removes old playerdata entries)
        insertPlayerInfo(senderAddress, senderPort, receiveData);

        // clear receive buffer
        _dataBuffer.remove(senderAddressLabel);
    }
}
