#include "statuschecker.h"

void StatusChecker::onTicker()
{

    // get next recent item from database (id > index)
    QSqlQuery q = getNextServer(_dbIndex);

    if ( q.next() )
    {
        // get server address from query
        _dbIndex                     = q.value(0).toInt();
        QHostAddress   remoteAddress = QHostAddress( q.value(1).toString() );
        unsigned short remotePort    = static_cast<unsigned short>(q.value(2).toInt());

        // create datagram with info- or status request
        QNetworkDatagram udpDatagram(_udpRequest.toUtf8(), remoteAddress, remotePort);

        // and send
        _udpSocket.writeDatagram(udpDatagram);

        // readyRead miss workaround
        if ( _udpSocket.hasPendingDatagrams() )
        {
            /* WORKAROUND INFO
             * _udpSocket.bytesAvailable() > 0 and _udpSocket.hasPendingDatagrams(),
             * but apparently no readyRead signal was emitted. As a result, incoming data
             * is no longer processed. Temporary fix until the cause has been found:
             * emit readyRead manually when datagrams are available. It is still possible
             * that the ticker is faster than the readyRead-bound function and that readyRead
             * was issued correctly, so we count two ticks of missed read calls. If the
             * readyRead signal was correctly issued, the onUdpResponseRead function will
             * reset the missed readcall counter. Even when botched, it is better to emit the
             * same signal twice, rather than not at all (onUdpResponseRead has a failsaife
             * for duplicate/redundant calls).
             *
             * Other info:
             * is this related to https://www.qtcentre.org/threads/64370-QUdpSocket-readyRead-failure ?
             *
             * Displaying readyread state and available data:
            qDebug() << "bytes available: "
                     << _udpSocket.bytesAvailable()
                     << "pending datagrams: "
                     << _udpSocket.hasPendingDatagrams()
                     ;
             */
            _missedReadCalls++;

            // two missed calls in 2 ticks, emit signal manually
            if ( _missedReadCalls > 1)
            {
                _coreObject->Log.logEvent("warning", "checker udp data not signalled: emitting readyread manually");
                emit _udpSocket.readyRead();
            }
        }  // end workaround

    } // end next
}
