#include "syncclient.h"

void SyncClient::onSyncRead()
{
    // reset timeout after receiving (any) data
    _timeOut.start();

    // read from tcp connection and append to buffer
    QByteArray receiveBuffer = _tcpSocket.readAll();
    _rxBuffer.append( receiveBuffer );

    // prevent large heaps of text -- log only relevant message, not masterserver data
    if ( receiveBuffer.length() > 30 )
    {
        // log size of data
        _coreObject->Log.logEvent("tcp", QStringLiteral("%1 sent %2 characters")
                                  .arg(_clientLabel, QString::number(receiveBuffer.length()) ) );
    }
    else
    {
        // log message
        _coreObject->Log.logEvent("tcp", QStringLiteral("%1 sent '%2'")
                                  .arg(_clientLabel, receiveBuffer.data()) );
    }

    // remote masterserver opens with secure challenge
    if ( _rxBuffer.contains("secure") )
    {
        // parse to hash
        QMultiHash<QString, QString> receiveData = parseGameSpy0Buffer(receiveBuffer);

        // generate response
        QStringList response = replyQuery(receiveData);

        // return response
        _tcpSocket.write(response.join("").toLatin1());

        // sync request
        QString request = QStringLiteral("\\sync\\%1\\msid\\%2")
                .arg(_coreObject->Settings.SyncerSettings.syncGames,
                     _coreObject->masterserverIdentity);
        _tcpSocket.write(request.toLatin1());

        // all relevant information received. clear buffer for next interaction
        _rxBuffer = "";
        return;
    }

    if ( _rxBuffer.contains("final") )
    {
        // parse to hash: receivedData format is {gamename} => {string of addresses}
        QMultiHash<QString, QString> receiveData = parseGameSpy0Buffer(_rxBuffer);
        receiveData.remove("final"); // prevent "final" from registering as gamename

        // count number of addresses for logging
        int totalServerCount = 0;

        // parse to list of list of <ServerInfo>
        QHashIterator<QString,QString> receiveDataIterator(receiveData);
        while ( receiveDataIterator.hasNext() )
        {
            // {gamename} => {string of addresses}
            receiveDataIterator.next();
            QString gamename          = receiveDataIterator.key();
            QString addressBufferList = receiveDataIterator.value();

            // split address list in ip:port
            QStringListIterator listIterator( addressBufferList.split(" ", QString::SkipEmptyParts) );
            while ( listIterator.hasNext() )
            {
                // construct server info object; both with ipv4/ipv6 addresses, the block after the
                // last ':' is the port number. Ipv6 blocks got split and joined by remaining ':' while
                // ipv4 addresses remain untouched ( '.' seperator). Store as ipv6 in database.
                QStringList     address = listIterator.next().split(":");
                unsigned short  remotePort      = address.takeLast().toUShort();
                QHostAddress    remoteAddress   = QHostAddress( QHostAddress( address.join(":") ).toIPv6Address() );

                // valid address?
                if ( ! remoteAddress.isNull() and remotePort > 0 )
                {
                    // if it does not exist in the db, insert
                    if ( ! updateSyncedServer(remoteAddress, remotePort) )
                    {
                        // add
                        insertServer(remoteAddress, remotePort, gamename, false);

                        // log
                        _coreObject->Log.logEvent("sync_add", QStringLiteral("%1:%2 for %3")
                                                  .arg(remoteAddress.toString(), QString::number(remotePort), gamename));
                    }
                }
                totalServerCount++;
            } // has next address
        } // has next game

        // report in log
        _coreObject->Log.logEvent("sync", QStringLiteral("received %1 servers in %2 games from %3")
                                  .arg( QString::number(totalServerCount),
                                        QString::number(receiveData.count()),
                                        _clientLabel)
                                  );
    } // if final

    // else keep appending data until \\final\\ is received
}
