#ifndef UDPDATASTRUCTURE_H
#define UDPDATASTRUCTURE_H

#include <QHostAddress>
#include <QDateTime>

// heartbeat struct for incoming udp heartbeats
struct UdpData
{
    // update time or creation time
    qint64 time = QDateTime::currentSecsSinceEpoch();

    // address information (redundant for convenience)
    QHostAddress    ip = QHostAddress();
    unsigned short  port = 0;

    // raw data from socket
    QString rawData = "";

    // parsed data
    QMultiHash<QString, QString> serverData;
};

#endif // UDPDATASTRUCTURE_H
