#include "listenclienthandler.h"

QByteArray ListenClientHandler::compileServerlist (const QString &gamename,
                                                   const int     &serverAge_s,
                                                   const bool    &cmp,
                                                   const bool    &setIPv6)
{
    // retrieve servers from database (both direct and sync)
    QSqlQuery q = selectServerList( gamename, serverAge_s, true);

    // output array
    QByteArray compiledList;
    QDataStream dsList(&compiledList,QIODevice::WriteOnly);

    // iterate through resulting queries and add to compile list
    while (q.next())
    {
        QHostAddress   ip   = QHostAddress( q.value(0).toString() );
        unsigned short port = q.value(1).value<unsigned short>();

        // add server to list (compressed/cmp or plaintext)
        if (cmp)
        {
            // IPv4 or IPv6 addresses as output
            if (setIPv6)
            {
                Q_IPV6ADDR addr = ip.toIPv6Address();

                for (short i = 0; i <= 16; i++)
                    dsList << addr[i];

                dsList << port;
            }
            else
            {
                dsList << ip.toIPv4Address() << port;
            }
        }
        else // plaintext output
        {
            // IPv4 or IPv6 addresses as output
            ip = (setIPv6)
                    ? QHostAddress( ip.toIPv6Address() )
                    : QHostAddress( ip.toIPv4Address() );
            compiledList += QStringLiteral("\\ip\\%1:%2").arg(ip.toString(), QString::number(port));
        }

    } // while next

    // terminator after list
    compiledList.append("\\final\\");

    // list compiled
    return compiledList;
}
