#include "../beaconserver.h"

void BeaconServer::onUdpRead()
{
    while ( _udpSocket.hasPendingDatagrams() )
    {
        // get sender and payload
        QNetworkDatagram    datagram        = _udpSocket.receiveDatagram();
        QHostAddress        senderAddress   = QHostAddress( datagram.senderAddress().toIPv6Address() );
        int                 senderPort      = datagram.senderPort();
        QString             receiveBuffer   = datagram.data();

        _coreObject->Log.logEvent("udp", QStringLiteral("%1:%2 sent '%3'")
                           .arg(senderAddress.toString(), QString::number(senderPort), receiveBuffer) );

        // apparently it is possible to receive empty data packets. ignore them for now (happens when a query port is forwarded to a game port)
        if (receiveBuffer.length() <= 0)
        {
            _coreObject->Log.logEvent("udp", QStringLiteral("%received empty packet from 1:%2")
                               .arg(senderAddress.toString(), QString::number(senderPort), receiveBuffer) );
            continue;
        }

        /*
         * determine protocol and response based on the first character (backslash, byte value, ... )
         */

        unsigned short protocol_chooser = receiveBuffer.at(0).unicode();
        switch(protocol_chooser)
        {
          case 92: // GameSpy v0 protocol
            {      // Used by Unreal/UT, Postal 2, Rune, Deus Ex, Serious Sam, others
                processHeartbeatGamespy0(datagram, senderAddress, senderPort, receiveBuffer.toLatin1());
                break;
            }

            default:
            {
                // received another type of query?
                _coreObject->Log.logEvent("unknown", QStringLiteral("received unknown message %1 from %2")
                               .arg(receiveBuffer, senderAddress.toString()) );
                break;
            }
        }

    } // while pending datagrams
}
