
#define _MULTI_THREADED
#include <stdio.h>
#include <winsock2.h>
#include <pthread.h>
#include <time.h>

#define BUFFERSIZE 1024
#define IPDATASIZE 1048576
#define GAMECOUNT 3188
#define DBSIZE 8192

#define MAXLISTENCONNECTIONS 1024   // change to 4096 for release, and launch MSx with "ulimit -Sn 4096"
#define UDPPORT 27900
#define TCPPORT 28900
#define TCPTHREADTIMEOUT 5000

#define UCASEALPHA "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

extern pthread_t thread;
extern pthread_attr_t threadAttr;

extern void udpInit();
extern void tcpInit();
extern void *udpMasterThread();
extern void *tcpMasterThread();
extern void *udpThread();
extern void *tcpThread();
extern void *tcpThreadCleanup();
extern void *tcpThreadTimer();
extern void initGSKeys();
SOCKET udpSocketDesc;
SOCKET tcpSocketDesc;

extern char *gsGamename[GAMECOUNT];
extern char *gsGamekey[GAMECOUNT];
extern char *dbAddress[GAMECOUNT][DBSIZE];
extern unsigned int dbAddressCount[GAMECOUNT];

extern unsigned char *gsseckey(unsigned char *dst, unsigned char *src, unsigned char *key, int enctype);

typedef struct tcpThreadArgStruct {
    unsigned int c;
    struct sockaddr_in clientAddress;
    int clientAddressLen;
} tcpThreadArgStruct;

typedef struct udpThreadArgStruct {
    char buffer[BUFFERSIZE];
    struct sockaddr_in clientAddress;
    int clientAddressLen;
} udpThreadArgStruct;
