
package MasterServer::Core;

use strict;
use warnings;
use AnyEvent;
use Exporter 'import';
use DBI;

our @EXPORT = qw | main |;

# Initialization script
sub main {
  my $self = shift;
  
  # keep several objects alive outside scope
  my %ae = ();
  
  # Start up
  $self->log("Starting 333networks Master Server (perl-sqlite) Application.");
  
  # Connect to database
  $self->{dbh} = DBI->connect(@{$self->{dblogin}}) 
    or die "Cannot connect: $DBI::errstr\n";
  $self->log("[OK] > Connected to the Master Database.");
  
  $self->{dbh}->do("PRAGMA synchronous = OFF");
  
  ##############################################################################
  ##
  ##   Initiate Scheduled tasks
  ##
  ##   - UdpBeacon catcher    (udp server)
  ##   - UBrowser TCP Server  (tcp server)
  ##
  ##   - Query the MasterServer periodically  (timer, tcp client)
  ##
  ##   - Database maintenance   (timer, dbi)
  ##
  ## (store objects in hash to keep them alive outside of each scope
  ##############################################################################
  $ae{BeaconCatcher}          = $self->BeaconCatcher();
  $ae{UBrowserServer}         = $self->UBrowserServer();
 
  $ae{MasterQueryScheduler}   = $self->MasterQueryScheduler();
  
  $ae{ScheduleMaintenance}    = $self->ScheduleMaintenance();

  ##############################################################################
  ##
  ##   Wait Loop
  ##
  ##   Prevents main program from ending
  ##############################################################################
  AnyEvent->condvar->recv;
 
}

1;
