//=============================================================================
// Ammo556.
//=============================================================================
class Ammo556DXN extends Ammo556;


//
// SimUseAmmo - Spawns shell casings client side
//
simulated function bool SimUseAmmo()
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;

	if ( AmmoAmount > 0 )
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		W = DeusExWeapon(Pawn(Owner).Weapon);

      if ((W != None) && ((W.NoiseLevel < 0.1) || W.bHasSilencer))
         shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
      else
         shell = spawn(class'ShellCasing',,, Owner.Location + offset);

		shell.RemoteRole = ROLE_None;

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}
	return False;
}

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		// use silent shells if the weapon has been silenced
		W = DeusExWeapon(Pawn(Owner).Weapon);
      if ( DeusExMPGame(Level.Game) != None )
      {
			if ( Level.NetMode == NM_ListenServer )
			{
				if ((W != None) && ((W.NoiseLevel < 0.1) || W.bHasSilencer))
					shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
				else
					shell = spawn(class'ShellCasing',,, Owner.Location + offset);

				shell.RemoteRole = ROLE_None;
			}
			else
	         shell = None;
      }
      else
      {
         if ((W != None) && ((W.NoiseLevel < 0.1) || W.bHasSilencer))
            shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
         else
            shell = spawn(class'ShellCasing',,, Owner.Location + offset);
      }

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}

	return False;
}

defaultproperties
{
	bShowInfo=true
	AmmoAmount=30
	MaxAmmo=300
	ItemName="5.56x45mm XVA"
	ItemArticle="some"
	PickupViewMesh=LodMesh'DeusExItems.Ammo762mm'
	LandSound=Sound'DeusExSounds.Generic.MetalHit1'
	Icon=Texture'fgrhk.Icons.Ammo556BeltIcon'
	largeIconWidth=46
	largeIconHeight=34
	Description="The 5.56x45mm XVA round is derived from the standard-issue NATO cartridge, noted for sacrificing hit damage for less recoil and more accuracy than the standard 7.62mm round."
	beltDescription="5.56x45mm"
	Mesh=LodMesh'DeusExItems.Ammo762mm'
	CollisionRadius=6.00
	CollisionHeight=0.75
	bCollideActors=true
     	MultiSkins(0)=Texture'fgrhk.Skins.Ammo556mmTex0'
}