//=============================================
// BERMission62Script.
//=============================================
class BERMission62Script expands MissionScript;

function InitStateMachine() {

    super.InitStateMachine();
    FirstFrame();

}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	Super.FirstFrame();

	if (localURL == "62_BERLIN_AIRBORNELAB")
	{

		if (!flags.GetBool('M62_PlayerHealed'))
		{
			Player.GoalCompleted('M61MeetChenLastT');
			Player.HealthHead = Max(50, Player.HealthHead);
			Player.HealthTorso =  Max(50, Player.HealthTorso);
			Player.HealthLegLeft =  25;
			Player.HealthLegRight =  25;
			Player.HealthArmLeft =  Max(50, Player.HealthArmLeft);
			Player.HealthArmRight =  Max(50, Player.HealthArmRight);
			Player.GenerateTotalHealth();
			flags.SetBool('M62_PlayerHealed', True,, 63);
		}


	}
	if (localURL == "62_BERLIN_STREETS")
	{

		if (!flags.GetBool('M62_ArrivedAtNEU'))
		{
			Player.GoalCompleted('GoToNeustadt');
			Player.StartDataLinkTransmission("DL_M62_WelcomeToNEU");
			flags.SetBool('M62PlayerArrivedAtBerlin', True,, 63);
			flags.SetBool('M62_ArrivedAtNEU', True,, 63);
		}


	}
	if (localURL == "62_BERLIN_XVAINTERIOR")
	{

		if (!flags.GetBool('M62_ArrivedAtXVA'))
		{
			Player.GoalCompleted('M62InfiltrateXVA');
			flags.SetBool('M62_ArrivedAtXVA', True,, 63);
		}


	}



}

function Timer()
{
	local int count;
	local ScriptedPawn pawn;
	local NumberOne NumberOne;
	local AlexiaNovikova AlexiaNovikova;
	local DavidYoon DavidYoon;
	local UNATCOTroop UNATCOTroop;
	local LanaZavich LanaZavich;
	local MJ12Troop troop;
	local XVATroop XVATroop;
	local XVAOfficer XVAOfficer;
	local DeusExMover M;
	local SpawnPoint SP;
	local Actor A;
	local FolderOpen FolderOpen;
	local MJ12Commando commando;
	local AutoTurret turret;
	local SecurityCamera cam;

   Super.Timer();

if (localURL == "62_BERLIN_AIRBORNELAB")
{
		if (flags.GetBool('AntonovClues01') && flags.GetBool('AntonovClues02') && flags.GetBool('AntonovClues03') && !flags.GetBool('M62PlanecubesOK'))
		{
			Player.GoalCompleted('M62DiscoverPlaneClues');
			flags.SetBool('IngramFoundPlaneCubes', True,, 0);
			flags.SetBool('M62PlanecubesOK', True,, 63);
		}
		if (!flags.GetBool('FolderGag'))
		{
		foreach AllActors(class'FolderOpen', FolderOpen)
		{
			if (flags.GetBool('CoatGEPGun'))
			{
				if ((FolderOpen.BindName == "GEPCoat"))
				{
				FolderOpen.bHidden = False;
				flags.SetBool('FolderGag', True,, 63);
				}
			}
			if (flags.GetBool('CoatBeer'))
			{
				if ((FolderOpen.BindName == "BeerCoat"))
				{
				FolderOpen.bHidden = False;
				flags.SetBool('FolderGag', True,, 63);
				}
			}
			if (flags.GetBool('CoatWine'))
			{
				if ((FolderOpen.BindName == "WineCoat"))
				{
				FolderOpen.bHidden = False;
				flags.SetBool('FolderGag', True,, 63);
				}
			}
			if (flags.GetBool('CoatLiquor'))
			{
				if ((FolderOpen.BindName == "LiquorCoat"))
				{
				FolderOpen.bHidden = False;
				flags.SetBool('FolderGag', True,, 63);
				}
			}
			if (!flags.GetBool('CoatGEPGun') && !flags.GetBool('CoatBeer') && !flags.GetBool('CoatLiquor') && !flags.GetBool('CoatWine'))
			{
				if ((FolderOpen.BindName == "NormalCoat"))
				{
				FolderOpen.bHidden = False;
				flags.SetBool('FolderGag', True,, 63);
				}
			}
		}
		}
		if (flags.GetBool('EnterNumberOne') &&
			!flags.GetBool('BER_Introduced'))
		{
			Player.StartDataLinkTransmission("DL_M62_IAmNumberOne");
			flags.SetBool('BER_Introduced', True,, 63);
		}
		if (flags.GetBool('NumberOneAppears') &&
			!flags.GetBool('BER_Appeared'))
		{
			foreach AllActors(class'NumberOne', NumberOne)
				NumberOne.EnterWorld();
			flags.SetBool('BER_Appeared', True,, 63);
		}
		if (flags.GetBool('NumberOnePlane_Played') &&
			!flags.GetBool('BER_Holoremoved'))
		{
			foreach AllActors(class'NumberOne', NumberOne)
				NumberOne.LeaveWorld();
			flags.SetBool('BER_Holoremoved', True,, 63);
		}
		if (flags.GetBool('M62CargoDoor1Opened') && flags.GetBool('M62CargoDoor2Opened')  &&
			!flags.GetBool('BER_CargodoorsOpened'))
		{
			Player.GoalCompleted('M62OpenCargo');
			flags.SetBool('BER_CargodoorsOpened', True,, 63);
		}

		if (flags.GetBool('SecuritySystem2') && !flags.GetBool('ANTONOV_SecurityBlewIt'))
		{
			Player.GoalCompleted('M62NoPlaneAlarms');
			flags.SetBool('ANTONOV_SecurityBlewIt', True,, 63);
		}

		if (flags.GetBool('PlaneSECActive') && !flags.GetBool('ANTONOV_SecurityActive'))
		{
			flags.SetBool('M62SecurityRestore', false,, 63);
			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'CargoDoor1') || (M.Tag == 'CargoDoor2'))
				{
					// close and lock the door
					if (M.KeyNum != 0)
						M.Trigger(None, None);
					M.bBreakable = False;
					M.bPickable = False;
					M.bFrobbable = False;
					M.bLocked = True;
				}
			}
			foreach AllActors(class'Actor', A, 'OttawaPad')
			{
						SP = GetSpawnPoint('ottawapoint');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			foreach AllActors(class'Actor', A, 'CalgaryPad')
			{
						SP = GetSpawnPoint('calgarypoint');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			foreach AllActors(class'Actor', A, 'Ottawabust')
			{
						SP = GetSpawnPoint('properpoint1');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			foreach AllActors(class'Actor', A, 'Calgarybust')
			{
						SP = GetSpawnPoint('properpoint2');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			foreach AllActors(class'Actor', A, 'SecurityBoxMover')
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'SS2Sound')
				A.Trigger(Self, Player);
			flags.SetBool('ANTONOV_SecurityActive', True,, 63);
			flags.SetBool('ANTONOV_SecurityDeActivated', False,, 63);
		}

		if (flags.GetBool('PlaneSECActive') && flags.GetBool('M62SecurityRestore') && !flags.GetBool('ANTONOV_SecurityDeActivated'))
		{
			flags.SetBool('PlaneSECActive', false,, 63);
			flags.SetBool('ANTONOV_SecurityActive', False,, 63);
			foreach AllActors(class'Actor', A, 'LockdownDefuse')
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'OttawaPad')
			{
						SP = GetSpawnPoint('properpoint1');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			foreach AllActors(class'Actor', A, 'CalgaryPad')
			{
						SP = GetSpawnPoint('properpoint2');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			foreach AllActors(class'Actor', A, 'Ottawabust')
			{
						SP = GetSpawnPoint('ottawapoint');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			foreach AllActors(class'Actor', A, 'Calgarybust')
			{
						SP = GetSpawnPoint('calgarypoint');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			foreach AllActors(class'Actor', A, 'SecurityBoxMover')
				A.Trigger(Self, Player);
			flags.SetBool('ANTONOV_SecurityDeActivated', True,, 63);
		}

		if (flags.GetBool('M62SecurityRestore') && !flags.GetBool('PlaneSECActive') && !flags.GetBool('ANTONOV_NadaHappens'))
		{
			foreach AllActors(class'Actor', A, 'Informa2Trig')
				A.Trigger(Self, Player);
			flags.SetBool('ANTONOV_NadaHappens', True,, 63);
		}


}

if (localURL == "62_BERLIN_AIRPORT")
   {

		if (flags.GetBool('M62AirportBooth') && flags.GetBool('XVA_Airport') && !flags.GetBool('NEU_JoinedXVA') && !flags.GetBool('RiggidyBraxicon4'))
		{
			foreach AllActors(class'Actor', A, 'MadBooth')
				A.Trigger(Self, Player);
			flags.SetBool('RiggidyBraxicon4', True,, 63);
		}
		if (!flags.GetBool('M62Antebellum1'))
		{
					foreach AllActors(class'DeusExMover', M, 'DoorGrande')
					if (M.bDestroyed)
					{
					foreach AllActors(class'Actor', A, 'BoothCheck')
					A.Trigger(Self, Player);
					flags.SetBool('M62Antebellum1', True,, 62);
					}
		}

		if (flags.GetBool('HutterStart') &&
			!flags.GetBool('HUT_Introlink'))
		{
			Player.StartDataLinkTransmission("DL_M62_HutterIntro");
			flags.SetBool('HUT_Introlink', True,, 63);
		}
		if (flags.GetBool('XVAMissionCompleted') &&
			!flags.GetBool('M62ZavichContacts'))
		{
			Player.StartDataLinkTransmission("DL_M62_ZavichContacts");
			flags.SetBool('M62ZavichContacts', True,, 63);
			foreach AllActors(class'LanaZavich', LanaZavich)
				LanaZavich.EnterWorld();
		}
		if (flags.GetBool('BerlinYoonDone') && flags.GetBool('NEU_JoinedXVA') && !flags.GetBool('HUT_IngramsBack'))
		{
				foreach AllActors(class'MJ12Troop', troop, 'TroopInsertion')
				{
				troop.EnterWorld();
				}
				flags.SetBool('HUT_IngramsBack', True,, 63);
			
		}
		if (flags.GetBool('SecuritySystem2') && !flags.GetBool('XVA_Airport'))
		{
				foreach AllActors(class'XVATroop', XVAtroop, 'XVATroopInsertion')
				{
				XVATroop.EnterWorld();
				}
				foreach AllActors(class'XVAOfficer', XVAOfficer, 'XVAOfficerInsertion')
				{
				XVAofficer.EnterWorld();
				}
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = False;
				foreach AllActors(class'Actor', A, 'BotInsanity')
				A.Trigger(Self, Player);
				flags.SetBool('XVA_Airport', True,, 63);
			
		}
		if (flags.GetBool('NEU_JoinedXVA') && !flags.GetBool('FriendlyXVA'))
		{
			foreach AllActors(class'Actor', A, 'XVAlliance')
				A.Trigger(Self, Player);
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
			flags.SetBool('FriendlyXVA', True,, 63);
		}
		if (flags.GetBool('NEU_JoinedMJ12') && !flags.GetBool('XVASkedaddle'))
		{
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = False;
				foreach AllActors(class'XVATroop', XVAtroop, 'XVATroopInsertion')
				{
				XVATroop.LeaveWorld();
				}
				foreach AllActors(class'XVAOfficer', XVAOfficer, 'XVAOfficerInsertion')
				{
				XVAofficer.LeaveWorld();
				}
				flags.SetBool('XVASkedaddle', True,, 63);
			
		}

   }


if (localURL == "62_BERLIN_XVAINTERIOR")
   {

		if (flags.GetBool('EnterNovikova') &&
			!flags.GetBool('XVA_Appeared'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
				AlexiaNovikova.EnterWorld();
			flags.SetBool('XVA_Appeared', True,, 63);
		}
		if (flags.GetBool('MeetNovikova_Played') &&
			!flags.GetBool('XVA_Holoremoved'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
				AlexiaNovikova.LeaveWorld();
			flags.SetBool('XVAMissionCompeted', True,, 63);
			flags.SetBool('XVA_Holoremoved', True,, 63);
		}

   }

if (localURL == "62_BERLIN_XVACOMPLEX")
   {

		if (flags.GetBool('SewerFlail_Dead') && !flags.GetBool('Sickbastarding'))
		{
			foreach AllActors(class'DeusExMover', M)
				{
					if (M.Tag == 'Ski4Mover')
					{
						M.bBreakable = True;
						M.bPickable = True;
						M.DoorStrength = 0.1;
						M.lockStrength = 0.1;
					}
				}
			foreach AllActors(class'DeusExMover', M)
				{
					if (M.Tag == 'Ski3Manhole')
					{
						M.bBreakable = True;
						M.bPickable = True;
						M.DoorStrength = 0.1;
						M.lockStrength = 0.1;
					}
				}
			flags.SetBool('Sickbastarding', True,, 63);
		}

   }


if (localURL == "62_BERLIN_STREETS")
   {
		if(flags.GetBool('SpiderAlbert_Dead') && !flags.GetBool('AlbertBonus1'))
		{
				foreach AllActors(class'Actor', A, 'SpiderDemise6')
				A.Trigger(Self, Player);
				flags.setbool('AlbertBonus1',true,, 63);
		}

		if(flags.getbool('DavidYoon_Unconscious') && !flags.getbool('YoonSpecialCase'))
		{

				flags.setbool('DavidYoon_Dead',false,, 69);
				flags.setbool('YoonSpecialCase',true,, 63);
		}
		if (!flags.GetBool('M62CommandONE1'))
		{
			count = 0;
			foreach AllActors(class'MJ12Commando', commando)
				count++;

			if (count == 0)
			{
				Player.GoalCompleted('M62CommanDead');
				foreach AllActors(class'Actor', A, 'JuneSkills2351')
				A.Trigger(Self, Player);
				flags.SetBool('M62CommandONE1', True,, 63);
			}
		}
		if (!flags.GetBool('M62_UNATCOMortal'))
		{
			if (flags.GetBool('XVAMissionCompleted'))
			{
			foreach AllActors(class'DavidYoon', DavidYoon)
				{
				DavidYoon.EnterWorld();
				}
			foreach AllActors(class'DeusExMover', M)
				{
					if (M.Tag == 'YoonDoor')
					{
						M.bLocked = False;
					}
				}
				foreach AllActors(class'Actor', A, 'Yoopens')
				A.Trigger(Self, Player);
				flags.SetBool('M62_UNATCOMortal', True,, 63);
			}
		}
		if (flags.GetBool('NEU_JoinedMJ12') && !flags.GetBool('YoonHouseFlag') && !flags.GetBool('AllegianceSolved'))
		{
				Player.GoalCompleted('M62JoinedXVA');
				foreach AllActors(class'DavidYoon', DavidYoon)
				{
				DavidYoon.EnterWorld();
				}

				foreach AllActors(class'ScriptedPawn', pawn)
				{
				if (pawn.BindName == "DavidYoon")
					{
						SP = GetSpawnPoint('Yoon2Spawnpoint');
						if (SP != None)
						{
							pawn.SetLocation(SP.Location);
							pawn.SetRotation(SP.Rotation);
							pawn.SetOrders('Standing',, True);
							pawn.SetHomeBase(SP.Location, SP.Rotation);
						}
					}
				}

			foreach AllActors(class'Actor', A, 'M62YoonHatesIngram')
				A.Trigger(Self, Player);
				foreach AllActors(class'UNATCOTroop', UNATCOTroop, 'TroopAmbush')
				{
				UNATCOTroop.EnterWorld();
				}
			foreach AllActors(class'Actor', A, 'Yawnpens2')
				A.Trigger(Self, Player);
				foreach AllActors(class'DeusExMover', M)
				{
					if (M.Tag == 'YoonDoor')
					{
						M.bFrobbable = True;
						M.bHighlight = True;
						M.bBreakable = True;
						M.bPickable = True;
						M.bIsDoor = True;
					}
				}
				flags.SetBool('AllegianceSolved', True,, 63);
			
		}

		if (flags.GetBool('NEU_JoinedMJ12') && flags.GetBool('DavidYoon_Dead') && !flags.GetBool('PostWanderingM62B'))
		{
				foreach AllActors(class'Actor', A, 'CultureTrigger')
				A.Trigger(Self, Player);
				flags.SetBool('PostWanderingM62B', True,, 63);
		}

		if (flags.GetBool('NEU_JoinedMJ12') && flags.GetBool('YoonMeetingSpot') && flags.GetBool('YoonDoorOpened') && !flags.GetBool('XVABetrayed'))
		{
				flags.SetBool('M62YoonAction', True,, 63);
				Player.GoalCompleted('M62ApprehendYoon');
				foreach AllActors(class'DavidYoon', DavidYoon)
				{
				DavidYoon.bInvincible = False;
				}
				Player.StartDataLinkTransmission("DL_M62_XVABetrayed");

				foreach AllActors(class'ScriptedPawn', pawn)
				{
				if (pawn.BindName == "NumberOne")
					{
						SP = GetSpawnPoint('Oneport');
						if (SP != None)
						{
							pawn.SetLocation(SP.Location);
							pawn.SetRotation(SP.Rotation);
							pawn.SetOrders('WaitingFor',, True);
							pawn.SetHomeBase(SP.Location, SP.Rotation);
						}
					}
				}
				flags.SetBool('XVABetrayed', True,, 63);
		
		}



		if (flags.GetBool('YoonDoorOpened') && flags.GetBool('YoonHouseFlag') && !flags.GetBool('NEU_JoinedMJ12') && !flags.GetBool('AllegianceSolved'))
		{
				flags.SetBool('NEU_JoinedXVA', True,, 0);
				Player.GoalCompleted('M62JoinedXVA');
				Player.GoalCompleted('M62JoinedMJ12');
				Player.GoalCompleted('M62SpiderAL');
				foreach AllActors(class'DeusExMover', M)
				{
					if (M.Tag == 'YoonDoor')
					{
						M.bLocked = True;
					}
				}
				flags.SetBool('AllegianceSolved', True,, 63);
			
		}
		if (flags.GetBool('BerlinYoonDone') && !flags.GetBool('NEU_YoonDone'))
		{
				flags.SetBool('NEU_MJ12Ambush', True,, 0);
				foreach AllActors(class'DeusExMover', M)
				{
					if (M.Tag == 'YoonDoor')
					{
						M.bFrobbable = True;
						M.bHighlight = True;
						M.bBreakable = True;
						M.bPickable = True;
						M.bIsDoor = True;
					}
				}
				foreach AllActors(class'ScriptedPawn', pawn)
					if (pawn.IsA('UNATCOTroop'))
						pawn.bInvincible = False;
				foreach AllActors(class'MJ12Troop', troop, 'TroopInsertion')
				{
				troop.EnterWorld();
				}
				foreach AllActors(class'Actor', A, 'Commandorren')
				A.Trigger(Self, Player);
				foreach AllActors(class'MJ12Commando', commando)
				{
				commando.EnterWorld();
				}
				foreach AllActors(class'Actor', A, 'FuryLink')
				A.Trigger(Self, Player);
				Player.StartDataLinkTransmission("DL_M62_Novinstruct");
				foreach AllActors(class'NumberOne', NumberOne)
				{
				NumberOne.LeaveWorld();
				}
				foreach AllActors(class'DavidYoon', DavidYoon)
				{
				DavidYoon.bInvincible = False;
				}
				flags.SetBool('NEU_YoonDone', True,, 63);
			
		}
		if (flags.GetBool('FuryRage') &&
			!flags.GetBool('RagingFury'))
		{
			Player.StartDataLinkTransmission("DL_M62_Furious");
			flags.SetBool('RagingFury', True,, 63);
		}
		if (flags.GetBool('AnotherChecker') && !flags.GetBool('NEU_JoinedMJ12'))
		{
				foreach AllActors(class'Actor', A, 'AnotherDoorTrigger')
				A.Trigger(Self, Player);
		}
		if (flags.GetBool('YetAnotherChecker') && flags.GetBool('NEU_JoinedMJ12') && !flags.GetBool('NEU_Whatever'))
		{
				foreach AllActors(class'ScriptedPawn', pawn)
				{
				if (pawn.BindName == "DavidYoon")
					{
						SP = GetSpawnPoint('Yoon2Spawnpoint');
						if (SP != None)
						{
							pawn.SetLocation(SP.Location);
							pawn.SetRotation(SP.Rotation);
							pawn.SetOrders('Standing',, True);
							pawn.SetHomeBase(SP.Location, SP.Rotation);
						}
					}
				}
				flags.SetBool('NEU_Whatever', True,, 63);
		}
		if (flags.GetBool('M62YoonAction') && !flags.GetBool('NEU_YoonieBoonie'))
		{
				foreach AllActors(class'DeusExMover', M)
				{
					if (M.Tag == 'M62MJ12EntryDoor0A')
					{
						M.bFrobbable = True;
						M.bHighlight = True;
						M.bBreakable = True;
						M.bPickable = True;
						M.Trigger(None, None);
					}
					else if (M.Tag == 'M62MJ12EntryDoor1A')
					{
						M.bFrobbable = True;
						M.bHighlight = True;
						M.bBreakable = True;
						M.bPickable = True;
						M.Trigger(None, None);
					}
					else if (M.Tag == 'YoonHidemover')
					{
						M.bFrobbable = True;
						M.bHighlight = True;
						M.bBreakable = True;
						M.bPickable = True;
						M.Trigger(None, None);
					}
				}
				flags.SetBool('NEU_YoonieBoonie', True,, 63);
		}

   }
}
defaultproperties
{
}
