//=============================================================================
// DXNMission59Script.
//=============================================================================
class DXNMission59Script extends MissionScript;

var byte savedSoundVolume;
var float endgameDelays[4];
var float endgameTimer;
var localized string endgameQuote[18];
var HUDMissionStartTextDisplay quoteDisplay;
var bool bQuotePrinted;
var Float      displayTime;

// ----------------------------------------------------------------------
// InitStateMachine()
// ----------------------------------------------------------------------

function InitStateMachine()
{
	Super.InitStateMachine();

	// Destroy all flags!
	if (flags != None)
		flags.DeleteAllFlags();

	// Set the PlayerTraveling flag (always want it set for 
	// the intro and endgames)
	flags.SetBool('PlayerTraveling', True, True, 0);
}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{

	Super.FirstFrame();
	

	if (player != None)
	{
		// turn down the sound so we can hear the speech
		savedSoundVolume = SoundVolume;
		SoundVolume = 50;
		Player.SetInstantSoundVolume(SoundVolume);


	}

}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	// restore the sound volume
	SoundVolume = savedSoundVolume;
	Player.SetInstantSoundVolume(SoundVolume);


	Super.PreTravel();



}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{

	local MichaelHamner NewsAnnouncer;
	Super.Timer();

	// After the Intro conversation is over, tell the player to go on
	// to the next map (which will either be the main menu map or 
	// the first game mission if we're starting a new game.

	if (localURL == "59_INTRO")
	{
		if(flags.GetBool('M59GiveMeText1') && !flags.GetBool('M59Step1'))
			{
			if (!bQuotePrinted)
			PrintEndgameQuote(0);
			flags.SetBool('M59Step1', True,, 60);
			}
		if(flags.GetBool('M59GiveMeText2') && !flags.GetBool('M59Step2'))
			{
			bQuotePrinted=False;
			if (!bQuotePrinted)
			PrintEndgameQuote(1);
			flags.SetBool('M59Step2', True,, 60);
			}
		if(flags.GetBool('M59GiveMeText3') && !flags.GetBool('M59Step3'))
			{
			bQuotePrinted=False;
			if (!bQuotePrinted)
			PrintEndgameQuote(2);
			flags.SetBool('M59Step3', True,, 60);
			}
		if(flags.GetBool('M59GiveMeText4') && !flags.GetBool('M59Step4'))
			{
			bQuotePrinted=False;
			if (!bQuotePrinted)
			PrintEndgameQuote(3);
			flags.SetBool('M59Step4', True,, 60);
			}
		if(flags.GetBool('M59GiveMeText5') && !flags.GetBool('M59Step5'))
			{
			bQuotePrinted=False;
			if (!bQuotePrinted)
			PrintEndgameQuote(4);
			flags.SetBool('M59Step5', True,, 60);
			}
		if(flags.GetBool('M59GiveMeText6') && !flags.GetBool('M59Step6'))
			{
			bQuotePrinted=False;
			if (!bQuotePrinted)
			PrintEndgameQuote(5);
			flags.SetBool('M59Step6', True,, 60);
			}
		if(flags.GetBool('M59GiveMeText7') && !flags.GetBool('M59Step7'))
			{
			bQuotePrinted=False;
			if (!bQuotePrinted)
			PrintEndgameQuote(6);
			flags.SetBool('M59Step7', True,, 60);
			}
		if(flags.GetBool('M59GiveMeText8') && !flags.GetBool('M59Step8'))
			{
			bQuotePrinted=False;
			if (!bQuotePrinted)
			PrintEndgameQuote(7);
			flags.SetBool('M59Step8', True,, 60);
			}
		if(flags.GetBool('M59GiveMeText9') && !flags.GetBool('M59Step9'))
			{
			bQuotePrinted=False;
			if (!bQuotePrinted)
			PrintEndgameQuote(8);
			flags.SetBool('M59Step9', True,, 60);
			}
	}

	if (flags.GetBool('DXNIntroStartTalking') && !flags.GetBool('DXNIntro2'))
	{
	if (player != None)
	{
		// Make sure all the flags are deleted.
		DeusExRootWindow(Player.rootWindow).ResetFlags();

		// Find our buddy NewsAnnouncer, because he has the conversation!
		foreach AllActors(class'MichaelHamner', NewsAnnouncer)
			break;

		if (NewsAnnouncer != None)
		{
			// Start the conversation
			player.StartConversationByName('IntroDXN', NewsAnnouncer, False, True);
		}

		// turn down the sound so we can hear the speech
		flags.SetBool('DXNIntro2', True,, 69);
	}
	}


	if (flags.GetBool('IntroDXN_Played'))
	{
		flags.SetBool('IntroDXN_Played', False,, 69);
		player.PostIntro();
	}
	if (flags.GetBool('IntroDXN_Interrupted'))
	{
		flags.SetBool('IntroDXN_Interrupted', False,, 69);
		flags.SetBool('IntroDXN_Played', False,, 69);
		player.PostIntro();
	}
}

// ----------------------------------------------------------------------
// PrintEndgameQuote()
// ----------------------------------------------------------------------

function PrintEndgameQuote(int num)
{
	local int i;
	local DeusExRootWindow root;

	bQuotePrinted = True;

	root = DeusExRootWindow(Player.rootWindow);
	if (root != None)
	{
		quoteDisplay = HUDMissionStartTextDisplay(root.NewChild(Class'HUDMissionStartTextDisplay', True));
		if (quoteDisplay != None)
		{
			// quoteDisplay.displayTime = endgameDelays[num];
			quoteDisplay.SetWindowAlignments(HALIGN_Center, VALIGN_Center);

			for (i=0; i<2; i++)
				quoteDisplay.AddMessage(endgameQuote[2*num+i]);

			quoteDisplay.StartMessage();
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     displayTime=5.000000
     endgameDelays(0)=13.500000
     endgameDelays(1)=13.500000
     endgameDelays(2)=10.500000
     endgameDelays(3)=10.500000
     endgameQuote(0)="NIKUMUBEKI PRESENTS: A FastGamerr Project"
     endgameQuote(1)=""
     endgameQuote(2)="DEUS EX: NIHILUM"
     endgameQuote(3)=""
     endgameQuote(4)="ORIGINAL SOUNDTRACK BY RetroXor"
     endgameQuote(5)=""
     endgameQuote(6)="STARRING"
     endgameQuote(7)=""
     endgameQuote(8)="Richard Weigel AS Mad Ingram"
     endgameQuote(9)=""
     endgameQuote(10)="Audio lan AS Lana Zavich"
     endgameQuote(11)=""
     endgameQuote(12)="VERY SPECIAL THANKS to fender2k1 for UNATCO BORN"
     endgameQuote(13)=""
     endgameQuote(14)="ADDITIONAL LEVEL ARCHITECTURE from Deus Ex: Revision"
     endgameQuote(15)=""
     endgameQuote(16)="DEUS EX (2000) BY ION STORM AND EIDOS INTERACTIVE"
     endgameQuote(17)=""
}
