//=============================================================================
// DXNMission68Script.
//=============================================================================
class DXNMission68Script extends MissionScript;

var byte savedSoundVolume;
var byte savedMusicVolume;
var float endgameDelays[4];
var float endgameTimer;
var localized string endgameQuote[8];
var HUDMissionStartTextDisplay quoteDisplay;
var bool bQuotePrinted;
var Float      displayTime;

// ----------------------------------------------------------------------
// InitStateMachine()
// ----------------------------------------------------------------------

function InitStateMachine()
{
	Super.InitStateMachine();

	// Set the PlayerTraveling flag (always want it set for 
	// the intro and endgames)
	flags.SetBool('PlayerTraveling', True, True, 0);
}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{

	Super.FirstFrame();

	endgameTimer = 0.0;

	if (Player != None)
	{

		// Start the conversation
		

		// turn down the sound so we can hear the speech
	

		if (localURL == "68_ENDING_1")
			if(!flags.GetBool('StartIlluminati'))
			{
			if (!bQuotePrinted)
			PrintEndgameQuote(0);
			}
		if (localURL == "68_ENDING_2")
			if(!flags.GetBool('StartMJ12'))
			{
			if (!bQuotePrinted)
			PrintEndgameQuote(1);
			}
		if (localURL == "68_ENDING_3")
			if(!flags.GetBool('StartXVA'))
			{
			if (!bQuotePrinted)
			PrintEndgameQuote(2);
			}
		if (localURL == "68_ENDING_4")
			if(!flags.GetBool('StartSacrifice'))
			{
			if (!bQuotePrinted)
			PrintEndgameQuote(3);
			}

		savedSoundVolume = SoundVolume;
		SoundVolume = 52;
		Player.SetInstantSoundVolume(SoundVolume);


}

}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	// restore the sound volume
	SoundVolume = savedSoundVolume;
	Player.SetInstantSoundVolume(SoundVolume);


	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{

	local Actor A;
	local LienTakara LienTakara;

	Super.Timer();


		if (localURL == "68_ENDING_1")
			if(flags.GetBool('StartIlluminati') && !flags.GetBool('M68Ending1Started'))
			{
			Player.StartConversationByName('EndingIlluminati', Player, False, True);
			flags.SetBool('M68Ending1Started', True);
			bQuotePrinted = False;
			quoteDisplay.Destroy();
			}
			if(flags.GetBool('EndTheThing') && !flags.GetBool('M68ThingEnded'))
			{
			FinishCinematic();
			flags.SetBool('M68ThingEnded', True);
			}
		if (localURL == "68_ENDING_2")
			if(flags.GetBool('StartMJ12') && !flags.GetBool('M68Ending2Started'))
			{
			Player.StartConversationByName('EndingMJ12', Player, False, True);
					foreach AllActors(class'Actor', A, 'SkinColourTrigger')
					A.Trigger(Self, Player);
			flags.SetBool('M68Ending2Started', True);
			bQuotePrinted = False;
			quoteDisplay.Destroy();
			}

			if(!flags.GetBool('LienTakara_Dead') && flags.GetBool('LienRespectsIngramFinal') && !flags.GetBool('Polyakovski049'))
			{
					foreach AllActors(class'Actor', A, 'E2LienPortrait')
					A.Trigger(Self, Player);
			flags.SetBool('Polyakovski049', True);
			}

			if(!flags.GetBool('YakedoHatesIngram') && flags.GetBool('MeetYakedo_Played') && !flags.GetBool('Polyakovski051'))
			{
					foreach AllActors(class'Actor', A, 'E2YakePhot')
					A.Trigger(Self, Player);
			flags.SetBool('Polyakovski051', True);
			}

			if(flags.GetBool('EndTheThing') && !flags.GetBool('M68ThingEnded'))
			{
			FinishCinematic();
			flags.SetBool('M68ThingEnded', True);
			}
		if (localURL == "68_ENDING_3")
			if(flags.GetBool('StartXVA') && !flags.GetBool('M68Ending3Started'))
			{
			Player.StartConversationByName('EndingXVA', Player, False, True);
			flags.SetBool('M68Ending3Started', True);
			bQuotePrinted = False;
			quoteDisplay.Destroy();
			}
			if(flags.GetBool('EndTheThing') && !flags.GetBool('M68ThingEnded'))
			{
			FinishCinematic();
			flags.SetBool('M68ThingEnded', True);
			}
			if(flags.GetBool('IngramMeetDenton') && !flags.GetBool('DentonPrepared'))
			{
					foreach AllActors(class'Actor', A, 'UNATCODoore')
					A.Trigger(Self, Player);
			flags.SetBool('DentonPrepared', True);
			}
		if (localURL == "68_ENDING_4")
			if(!flags.GetBool('LienTakara_Dead') && flags.GetBool('LienRespectsIngramFinal') && !flags.GetBool('Dabado'))
			{
			foreach AllActors(class'LienTakara', LienTakara, 'LienTakara')
			LienTakara.LeaveWorld();
					foreach AllActors(class'Actor', A, 'TWMover')
					A.Trigger(Self, Player);
			flags.SetBool('Dabado', True);
			}
			if(flags.GetBool('StartSacrifice') && !flags.GetBool('M68Ending4Started'))
			{
			Player.StartConversationByName('EndingSacrifice', Player, False, True);
			flags.SetBool('M68Ending4Started', True);
			bQuotePrinted = False;
			quoteDisplay.Destroy();
			}
			if(flags.GetBool('EndTheThing') && !flags.GetBool('M68ThingEnded'))
			{
			FinishCinematic();
			flags.SetBool('M68ThingEnded', True);
			}

	if (flags.GetBool('EndgameExplosions'))
		ExplosionEffects();

	// After the conversation finishes playing, print a quote, delay a
	// bit, then scroll the credits and then return to the DXOnly map
	if (flags.GetBool('Endgame1_Played'))
	{
		if (!bQuotePrinted)
			PrintEndgameQuote(0);

		endgameTimer += checkTime;

		if (endgameTimer > endgameDelays[0])
			FinishCinematic();
	}
	else if (flags.GetBool('Endgame2_Played'))
	{
		if (!bQuotePrinted)
			PrintEndgameQuote(1);

		endgameTimer += checkTime;

		if (endgameTimer > endgameDelays[1])
			FinishCinematic();
	}
	else if (flags.GetBool('Endgame3_Played'))
	{
		if (!bQuotePrinted)
			PrintEndgameQuote(2);

		endgameTimer += checkTime;

		if (endgameTimer > endgameDelays[2])
			FinishCinematic();
	}
}

// ----------------------------------------------------------------------
// FinishCinematic()
// ----------------------------------------------------------------------

function FinishCinematic()
{
	local CameraPoint cPoint;

	if (quoteDisplay != None)
	{
		quoteDisplay.Destroy();
		quoteDisplay = None;
	}

	// Loop through all the CameraPoints and set the "nextPoint"
	// to None will will effectively cause them to halt.
	// This prevents the screen from fading while the credits are rolling.

	foreach player.AllActors(class'CameraPoint', cPoint)
		cPoint.nextPoint = None;

	flags.SetBool('EndgameExplosions', False);
	SetTimer(0, False);
	Player.ShowCredits(True);
}

// ----------------------------------------------------------------------
// PrintEndgameQuote()
// ----------------------------------------------------------------------

function PrintEndgameQuote(int num)
{
	local int i;
	local DeusExRootWindow root;

	bQuotePrinted = True;
	flags.SetBool('EndgameExplosions', False);

	root = DeusExRootWindow(Player.rootWindow);
	if (root != None)
	{
		quoteDisplay = HUDMissionStartTextDisplay(root.NewChild(Class'HUDMissionStartTextDisplay', True));
		if (quoteDisplay != None)
		{
			// quoteDisplay.displayTime = endgameDelays[num];
			quoteDisplay.SetWindowAlignments(HALIGN_Center, VALIGN_Center);

			for (i=0; i<2; i++)
				quoteDisplay.AddMessage(endgameQuote[2*num+i]);

			quoteDisplay.StartMessage();
		}
	}
}

// ----------------------------------------------------------------------
// ExplosionEffects()
// ----------------------------------------------------------------------

function ExplosionEffects()
{
	local float size;
	local int i;
	local Vector loc, endloc, HitLocation, HitNormal;
	local Actor HitActor;
	local MetalFragment frag;

	if (FRand() < 0.8)
	{
		// pick a random explosion size and modify everything accordingly
		size = FRand();

		// play a sound
		if (size < 0.5)
			Player.PlaySound(Sound'LargeExplosion1', SLOT_None, 2.0,, 16384);
		else
			Player.PlaySound(Sound'LargeExplosion2', SLOT_None, 2.0,, 16384);

		// have random metal fragments fall from the ceiling
		if (FRand() < 0.8)
		{
			for (i=0; i<Int(size*10.0); i++)
			{
				loc = Player.Location + 512.0 * VRand();
				loc.Z = Player.Location.Z;
				endloc = loc;
				endloc.Z += 1024.0;
				HitActor = Trace(HitLocation, HitNormal, endloc, loc, False);
				if (HitActor == None)
					HitLocation = endloc;

				// spawn some explosion effects
				if (size < 0.5)
					Spawn(class'ExplosionMedium',,, HitLocation+8*HitNormal);
				else
					Spawn(class'ExplosionLarge',,, HitLocation+8*HitNormal);

				if (FRand() < 0.5)
				{
					frag = Spawn(class'MetalFragment',,, HitLocation);
					if (frag != None)
					{
						frag.CalcVelocity(vect(20000,0,0),256);
						frag.DrawScale = 0.5 + 2.0 * FRand();
						if (FRand() < 0.75)
							frag.bSmoking = True;
					}
				}
			}
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     displayTime=5.000000
     endgameDelays(0)=13.500000
     endgameDelays(1)=13.500000
     endgameDelays(2)=10.500000
     endgameDelays(3)=10.500000
     endgameQuote(0)="2052 - THE WHITE HOUSE"
     endgameQuote(1)=""
     endgameQuote(2)="2052 - HONG KONG"
     endgameQuote(3)=""
     endgameQuote(4)="2052 - LIBERTY ISLAND"
     endgameQuote(5)=""
     endgameQuote(6)="2052"
     endgameQuote(7)=""
}
