//=============================================
// DYNMission67Script.
//=============================================
class DYNMission67Script expands MissionScript;

function InitStateMachine() 
{

    super.InitStateMachine();
    FirstFrame();

}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{

	local int count;
	local XVAEnforcer XVAEnforcer;
	local XVATroop XVATroop;
	local XVAOfficer XVAOfficer;

	if (localURL == "67_DYNAMENE_INNERSECTION")
	{
		if (!flags.GetBool('M67SecurityBoost'))
		{
			count = 0;

			foreach AllActors(class'XVAOfficer', XVAOfficer)
				count++;
			foreach AllActors(class'XVATroop', XVATroop)
				count++;
			foreach AllActors(class'XVAEnforcer', XVAEnforcer)
				count++;

			if (count > 0)
			flags.SetBool('M67SecurityBoost', True,, 68);
		}
	}

	Super.PreTravel();
}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	
	local Actor A;

	Super.FirstFrame();

	
	if (localURL == "67_DYNAMENE_EXTERIOR")
	{

		if (!flags.GetBool('M67_Open'))
		{
			Player.StartDataLinkTransmission("DL_M67_ZavichDeparts");
			flags.SetBool('M67_Open', True,, 68);
		}
	}

	if (localURL == "67_DYNAMENE_INNERSECTION")
	{
		if (!flags.GetBool('M67_Intro'))
		{
			Player.GoalCompleted('M67GetToDynamene');
			flags.SetBool('M67_Intro', True,, 68);
		}
	}

	if (localURL == "67_DYNAMENE_OUTERSECTION")
	{
		if (!flags.GetBool('M67_OISIntro'))
		{
			Player.StartDataLinkTransmission("DL_M67_XVA_Goals2");
			flags.SetBool('M67_OISIntro', True,, 68);
		}
		if (!flags.GetBool('M67SecurityBoost') && !flags.GetBool('M67_SBST12'))
		{
					foreach AllActors(class'Actor', A, 'CleanerDynaBonus')
					A.Trigger(Self, Player);
			flags.SetBool('M67_SBST12', True,, 68);
		}
	}
}

// ----------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------

function Timer()
{
	local NumberOne NumberOne;
	local AlexiaNovikova AlexiaNovikova;
	local MyComputerPersonal MyComputerPersonal;
	local MyComputerSecurity MyComputerSecurity;
	local SpawnPoint SP;
	local Actor A;
	local ScriptedPawn P;
	local BobPage BobPage;
	local MorganEverett MorganEverett;
	local EthanYoon EthanYoon;
	local XVATroop XVATroop;
	local XVAOfficer XVAOfficer;
	local XVAEnforcer XVAEnforcer;
	local int count;
	local AlarmUnit unit;
	local AutoTurret turret;
	local SecurityCamera cam;

   Super.Timer();

	if (localURL == "67_DYNAMENE_EXTERIOR")
	{
		if (flags.GetBool('M67IlluminatiEnding') && !flags.GetBool('IfYoonThenGone2'))
		{
			foreach AllActors(class'EthanYoon', EthanYoon)
				EthanYoon.LeaveWorld();
			flags.SetBool('IfYoonThenGone2', True,, 68);
		}
		if (flags.GetBool('M67MJ12Ending') && !flags.GetBool('IfYoonThenGone23'))
		{
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
			foreach AllActors(class'EthanYoon', EthanYoon)
				EthanYoon.LeaveWorld();
			flags.SetBool('IfYoonThenGone23', True,, 68);
		}
		if (flags.GetBool('M67SacrificeEnding') && !flags.GetBool('IfYoonThenGone24'))
		{
			foreach AllActors(class'EthanYoon', EthanYoon)
				EthanYoon.LeaveWorld();
			flags.SetBool('IfYoonThenGone24', True,, 68);
		}
		if (flags.GetBool('M67XVAEnding') && !flags.GetBool('IfYoonThenGone'))
		{
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
					foreach AllActors(class'Actor', A, 'XVAVictoireTrigger')
					A.Trigger(Self, Player);
			foreach AllActors(class'EthanYoon', EthanYoon)
				EthanYoon.LeaveWorld();
			foreach AllActors(class'XVAOfficer', XVAOfficer)
				XVAOfficer.bInvincible = True;
			foreach AllActors(class'XVATroop', XVATroop)
				XVATroop.bInvincible = True;
			foreach AllActors(class'XVAEnforcer', XVAEnforcer)
				XVAEnforcer.bInvincible = True;
			flags.SetBool('IfYoonThenGone', True,, 68);
		}

		if (!flags.GetBool('M67TrooperSlaughter'))
		{
			count = 0;

			// count the living
			foreach AllActors(class'XVATroop', XVATroop)
				count++;

			foreach AllActors(class'XVAEnforcer', XVAEnforcer)
				count++;

			foreach AllActors(class'XVAOfficer', XVAOfficer)
				count++;

			if (count < 3)
				flags.SetBool('M67TrooperSlaughter', True,, 68);
		}

	}



   if (localURL == "67_DYNAMENE_INNERSECTION")
   {
		if (!flags.GetBool('M67TrooperSlaughter'))
		{
			count = 0;

			// count the living
			foreach AllActors(class'XVATroop', XVATroop)
				count++;

			foreach AllActors(class'XVAEnforcer', XVAEnforcer)
				count++;

			foreach AllActors(class'XVAOfficer', XVAOfficer)
				count++;

			if (count < 3)
				flags.SetBool('M67TrooperSlaughter', True,, 68);
		}
		if (flags.GetBool('M67SacrificeEnding') && !flags.GetBool('HowDidYouGetThereM67'))
		{
					foreach AllActors(class'Actor', A, 'SacrificeItsOver')
					A.Trigger(Self, Player);
					flags.SetBool('HowDidYouGetThereM67', True,, 68);
		}
		if (flags.GetBool('MeetTheSamara_played') && !flags.GetBool('M67SmarFla1'))
		{
			foreach AllActors(class'ScriptedPawn', P)
			{
				if (P.BindName == "Satyakova")
				{
				P.bInvincible = False;
				}
			}
			flags.SetBool('M67SmarFla1', True,, 68);
		}
		if (flags.GetBool('AlexiaNovikova_Dead') && flags.GetBool('M67IlluminatiMissileLaunched') && flags.GetBool('M67IlluminatiSDUGoal') && !flags.GetBool('IllumiHandled2'))
		{
			Player.StartDataLinkTransmission("DL_M67_IlluminatiVictory");
			flags.SetBool('IllumiHandled2', True,, 68);
		}
		if (flags.GetBool('M67IlluminatiEnding') && !flags.GetBool('M02NotInDXN'))
		{
					foreach AllActors(class'Actor', A, 'SidneyGoesMad')
					A.Trigger(Self, Player);
			foreach AllActors(class'NumberOne', NumberOne)
				NumberOne.LeaveWorld();
					flags.SetBool('M02NotInDXN', True,, 68);
		}
		if (flags.GetBool('M67XVAEnding') && !flags.GetBool('M03NotInDXN'))
		{
					foreach AllActors(class'Actor', A, 'SidneyGoesMad')
					A.Trigger(Self, Player);
			foreach AllActors(class'NumberOne', NumberOne)
				NumberOne.LeaveWorld();
					foreach AllActors(class'Actor', A, 'XVAVictoireTrigger')
					A.Trigger(Self, Player);
			foreach AllActors(class'XVAOfficer', XVAOfficer)
				XVAOfficer.bInvincible = True;
			foreach AllActors(class'XVATroop', XVATroop)
				XVATroop.bInvincible = True;
			foreach AllActors(class'XVAEnforcer', XVAEnforcer)
				XVAEnforcer.bInvincible = True;
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
			flags.SetBool('M03NotInDXN', True,, 68);
		}
		if (flags.GetBool('AlexiaNovikova_Dead') && !flags.GetBool('XVADead'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
				AlexiaNovikova.Destroy();
			Player.GoalCompleted('XVAVisitSDU');
			Player.GoalCompleted('XVANukes');
			Player.GoalCompleted('XVAObservation');
			flags.SetBool('XVADead', True,, 68);
		}
		if (flags.GetBool('M67ConsistencyDown') && !flags.GetBool('ConsisOK'))
		{
			Player.StartDataLinkTransmission("DL_M67_SecurityIntro");
			flags.SetBool('ConsisOK', True,, 68);
		}
		if (flags.GetBool('M67ZavichDepowerDone') && !flags.GetBool('IGoals'))
		{
			Player.StartDataLinkTransmission("DL_M67_IlluminatiGoals");
			flags.SetBool('IGoals', True,, 68);
		}
		if (flags.GetBool('DL_M67_IlluminatiGoals_played') && !flags.GetBool('IGoalsChimp'))
		{
					foreach AllActors(class'Actor', A, 'M67ThatRaggedYDoo')
					A.Trigger(Self, Player);
			flags.SetBool('IGoalsChimp', True,, 68);
		}
		if (flags.GetBool('M67EnterNumberOne') && !flags.GetBool('EnterStoff'))
		{
			Player.StartDataLinkTransmission("DL_M67_NumberFive");
			flags.SetBool('EnterStoff', True,, 68);
		}
		if (flags.GetBool('XVAGoals_Done') && !flags.GetBool('Xoals'))
		{
			Player.StartDataLinkTransmission("DL_M67_ZavichWarns1");
			flags.SetBool('Xoals', True,, 68);
		}
		if (flags.GetBool('M67EnterNumberOne') &&
			!flags.GetBool('MJ12HoloAppeared'))
		{
			foreach AllActors(class'NumberOne', NumberOne)
				NumberOne.EnterWorld();
			flags.SetBool('MJ12HoloAppeared', True,, 68);
		}
		if (flags.GetBool('M67EnterNovikova') && !flags.GetBool('AlexiaNovikova_Dead') && !flags.GetBool('XVAHoloAppeared'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
				AlexiaNovikova.EnterWorld();
			flags.SetBool('XVAHoloAppeared', True,, 68);
		}
		if (flags.GetBool('NumberSix_Played') &&
			!flags.GetBool('MJ12HoloRemoved'))
		{
			foreach AllActors(class'NumberOne', NumberOne)
				NumberOne.LeaveWorld();
			flags.SetBool('MJ12HoloRemoved', True,, 68);
		}
		if (flags.GetBool('NovikovaPlead_Played') &&
			!flags.GetBool('XVAHoloRemoved'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
				AlexiaNovikova.LeaveWorld();
			flags.SetBool('XVAHoloRemoved', True,, 68);
		}
		if (flags.GetBool('M67SIUDone') &&
			!flags.GetBool('XVAHolo2'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
				AlexiaNovikova.EnterWorld();
			flags.SetBool('XVAHolo2', True,, 68);
		}
		if (flags.GetBool('XVAGoals_Played') &&
			!flags.GetBool('XVAHolo2Removed'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
				AlexiaNovikova.LeaveWorld();
			Player.StartDataLinkTransmission("DL_M67_ZavichWarns1");
			flags.SetBool('XVAHolo2Removed', True,, 68);
		}
		if (flags.GetBool('DL_M67_XVA_Goals2_Played') &&
			!flags.GetBool('XVAHolo3Removed'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
				AlexiaNovikova.LeaveWorld();
			Player.StartDataLinkTransmission("DL_M67_ZavichWarns1");
			flags.SetBool('XVAHolo3Removed', True,, 68);
		}
		if (flags.GetBool('M67SIURead1') && flags.GetBool('M67SIURead12') && flags.GetBool('M67SIURead13') && flags.GetBool('M67SIURead14') && !flags.GetBool('M67SIUDone'))
		{
			flags.SetBool('M67XVACubesRead', True,, 0);
			Player.GoalCompleted('XVAVisitSDU');
			flags.SetBool('M67SIUDone', True,, 68);
		}
		if (flags.GetBool('M67FlashSwitch') && !flags.GetBool('M67FlashDone'))
		{
			Player.ClientFlash(0.01, vect(10000,10000,10000));
			flags.SetBool('M67FlashDone', True,, 68);
		}
		if (flags.GetBool('M67Killswitch') && !flags.GetBool('FinalMJDown'))
		{
			Player.StartDataLinkTransmission("DL_M67_NumberSeven");
			foreach AllActors(class'Actor', A, 'MJ12Comp')
			{
						SP = GetSpawnPoint('MJ12point');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			foreach AllActors(class'MyComputerPersonal', MyComputerPersonal, 'FirstJED')
			{
			MyComputerPersonal.Destroy();
			}
			foreach AllActors(class'ScriptedPawn', P, 'SidneyThrax')
			{
				P.bInvincible = False;
			}
			flags.SetBool('FinalMJDown', True,, 68);
		}
		if (flags.GetBool('M67MJ12Ending') && !flags.GetBool('MJ12Victory'))
		{
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
			Player.StartDataLinkTransmission("DL_M67MJ12_Zavich");
			Player.GoalCompleted('IlluminatiWarheads');
			Player.GoalCompleted('IlluminatiNovikova');
			Player.GoalCompleted('IlluminatiSDU');
			Player.GoalCompleted('SacrificeGoal');
			Player.GoalCompleted('XVAVisitSDU');
			Player.GoalCompleted('XVANukes');
			Player.GoalCompleted('XVAObservation');
			flags.SetBool('MJ12Victory', True,, 68);
		}
		if (flags.GetBool('M67IlluminatiEnding') && !flags.GetBool('M00NotInDXN'))
		{
			foreach AllActors(class'MyComputerPersonal', MyComputerPersonal, 'MJ12Comp')
			{
			MyComputerPersonal.Destroy();
			}
			foreach AllActors(class'Actor', A, 'DummyComp')
			{
						SP = GetSpawnPoint('MJ12point');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			flags.SetBool('M00NotInDXN', True,, 68);
		}
		if (flags.GetBool('M67XVAEnding') && !flags.GetBool('M01NotInDXN'))
		{
			foreach AllActors(class'MyComputerPersonal', MyComputerPersonal, 'MJ12Comp')
			{
			MyComputerPersonal.Destroy();
			}
			foreach AllActors(class'Actor', A, 'DummyComp')
			{
						SP = GetSpawnPoint('MJ12point');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			flags.SetBool('M01NotInDXN', True,, 68);
		}


		if (flags.GetBool('M67EnfieStarts') &&
			!flags.GetBool('EnfieBorjar'))
		{
			foreach AllActors(class'XVATroop', XVATroop, 'DispatchTroop')
				XVATroop.EnterWorld();
			foreach AllActors(class'XVAEnforcer', XVAEnforcer, 'DispatchTeam2')
				XVAEnforcer.EnterWorld();
			foreach AllActors(class'XVAEnforcer', XVAEnforcer, 'DispatchTeam1')
				XVAEnforcer.EnterWorld();
			foreach AllActors(class'XVAEnforcer', XVAEnforcer, 'DispatchBackup')
				XVAEnforcer.EnterWorld();
			foreach AllActors(class'XVAEnforcer', XVAEnforcer, 'UpperEnforcers')
				XVAEnforcer.EnterWorld();
			flags.SetBool('EnfieBorjar', True,, 68);
		}


}

   if (localURL == "67_DYNAMENE_OUTERSECTION")
   {
		if (!flags.GetBool('M67TrooperSlaughter'))
		{
			count = 0;

			// count the living
			foreach AllActors(class'XVATroop', XVATroop)
				count++;

			foreach AllActors(class'XVAEnforcer', XVAEnforcer)
				count++;

			foreach AllActors(class'XVAOfficer', XVAOfficer)
				count++;

			if (count < 3)
				flags.SetBool('M67TrooperSlaughter', True,, 68);
		}
		if (flags.GetBool('M67SacrificeEnding') && !flags.GetBool('HowDidYouGetThereM67'))
		{
					foreach AllActors(class'Actor', A, 'SacrificeItsOver')
					A.Trigger(Self, Player);
					flags.SetBool('HowDidYouGetThereM67', True,, 68);
		}
		if (flags.GetBool('DL_M67_XVA_Goals2_Played') &&
			!flags.GetBool('XVANONRemoved'))
		{
			Player.StartDataLinkTransmission("DL_M67_ZavichWarns1");
			flags.SetBool('XVANONRemoved', True,, 68);
		}
		if (flags.GetBool('M67XVADead') && !flags.GetBool('XVADemise'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
			{
				AlexiaNovikova.bInvincible = False;
				AlexiaNovikova.HealthTorso = 0;
				AlexiaNovikova.Health = 0;
				AlexiaNovikova.TakeDamage(1, AlexiaNovikova, AlexiaNovikova.Location, vect(0,0,0), 'Shot');
				Player.StartDataLinkTransmission("DL_M67_NovikovaKilled");
			}
			ShakeEffects();
			foreach AllActors(class'Actor', A, 'DynaDoor87')
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'XVADSAlarm')
				A.Trigger(Self, Player);
			flags.SetBool('XVADemise', True,, 68);
		}
		if (flags.GetBool('AlexiaNovikova_Dead') &&
			!flags.GetBool('XVADeadOU'))
		{
			Player.GoalCompleted('IlluminatiNovikova');
			Player.GoalCompleted('XVAVisitSDU');
			Player.GoalCompleted('XVANukes');
			Player.GoalCompleted('XVAObservation');
			flags.SetBool('XVADeadOU', True,, 68);
		}
		if (flags.GetBool('M67MJ12Ending') && !flags.GetBool('BobAppears'))
		{
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
			foreach AllActors(class'Actor', A, 'ZapNoMore')
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'NoMoreDS')
				A.Trigger(Self, Player);
			foreach AllActors(class'BobPage', BobPage)
				BobPage.EnterWorld();
			foreach AllActors(class'Actor', A, 'ControlTowerDoor')
				A.Trigger(Self, Player);
			flags.SetBool('BobAppears', True,, 68);
		}
		if (flags.GetBool('M67IlluminatiEnding') && flags.GetBool('AlexiaNovikova_Dead') && flags.GetBool('M67IlluminatiMissileLaunched') && flags.GetBool('M67IlluminatiSDUGoal') && !flags.GetBool('mogAppears'))
		{
			foreach AllActors(class'Actor', A, 'ZapNoMore')
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'NoMoreDS')
				A.Trigger(Self, Player);
			foreach AllActors(class'MorganEverett', MorganEverett)
				MorganEverett.EnterWorld();
			foreach AllActors(class'Actor', A, 'ControlTowerDoor')
				A.Trigger(Self, Player);
			flags.SetBool('mogAppears', True,, 68);
		}
		if (flags.GetBool('M67XVAEnding') && !flags.GetBool('ComputerRestoreOK'))
		{
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
					foreach AllActors(class'Actor', A, 'XVAVictoireTrigger')
					A.Trigger(Self, Player);
			foreach AllActors(class'XVAOfficer', XVAOfficer)
				XVAOfficer.bInvincible = True;
			foreach AllActors(class'XVATroop', XVATroop)
				XVATroop.bInvincible = True;
			foreach AllActors(class'XVAEnforcer', XVAEnforcer)
				XVAEnforcer.bInvincible = True;
			foreach AllActors(class'MyComputerSecurity', MyComputerSecurity, 'JKEditComp')
			{
			MyComputerSecurity.Destroy();
			}
			foreach AllActors(class'Actor', A, 'XVAComputer')
			{
						SP = GetSpawnPoint('XVApoint');
						if (SP != None)
						{
							A.SetLocation(SP.Location);
							A.SetRotation(SP.Rotation);
						}
			}
			flags.SetBool('ComputerRestoreOK', True,, 68);
		}
		if (flags.GetBool('M67XVAEnding') && flags.GetBool('M67XVARestored') && !flags.GetBool('AllDoorsOpen'))
		{
			foreach AllActors(class'Actor', A, 'ControlTowerDoor') 
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'ObserElevD')
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'DynaDoor87')
				A.Trigger(Self, Player);
			Player.GoalCompleted('XVAObservation');
			Player.StartDataLinkTransmission("DL_M67_NovikovaInvite");
			flags.SetBool('AllDoorsOpen', True,, 68);
		}
		if (flags.GetBool('AlexiaNovikova_Dead') && flags.GetBool('M67IlluminatiMissileLaunched') && flags.GetBool('M67IlluminatiSDUGoal') && !flags.GetBool('IllumiHandled1'))
		{
			Player.StartDataLinkTransmission("DL_M67_IlluminatiVictory");
			flags.SetBool('IllumiHandled1', True,, 68);
		}
		if (flags.GetBool('M67IlluminatiSDUGoal') && !flags.GetBool('IllumiHandled100'))
		{
			Player.StartDataLinkTransmission("DL_M67_Dispenser");
			flags.SetBool('IllumiHandled100', True,, 68);
		}
  }

   if (localURL == "67_DYNAMENE_MISSILEUNIT")
   {
		if (flags.GetBool('DL_M67Sacrifice_played') &&
			!flags.GetBool('ByeByeXVA'))
		{
					foreach AllActors(class'Actor', A, 'DynameneFinalExplosions')
					A.Trigger(Self, Player);
			flags.SetBool('ByeByeXVA', True,, 68);
		}
	if (!flags.GetBool('M67_DeathSacrifice3'))
	{
		if (flags.GetBool('M67SacrificeEnding'))
		{
			if (Player.IsInState('Dying'))
			{
				flags.SetBool('M67_DeathSacrifice3', True,, 68);
				Level.Game.SendPlayer(Player, "68_ENDING_4");
			}
		}
	}
		if (flags.GetBool('M67FinalFlash') && !flags.GetBool('GarlickGunned'))
		{
			Player.ClientFlash(0.01, vect(10000,10000,10000));
			flags.SetBool('GarlickGunned', True,, 68);
		}
		if (flags.GetBool('M67JustAShaker') && !flags.GetBool('SundayBirdie'))
		{
			ShakeEffects();
			flags.SetBool('SundayBirdie', True,, 68);
		}
		if (flags.GetBool('M67JustAShaker2') && !flags.GetBool('SundayBirdie2'))
		{
			ShakeEffects();
			flags.SetBool('SundayBirdie2', True,, 68);
		}
		if (flags.GetBool('M67BoomShakaLaka') && !flags.GetBool('BigBnaged'))
		{
			ShakeEffects();
			foreach AllActors(class'XVATroop', XVATroop)
			{
				XVATroop.HealthTorso = 0;
				XVATroop.Health = 0;
				XVATroop.GotoState('Fleeing');
			}
			flags.SetBool('BigBnaged', True,, 68);
		}
		if (!flags.GetBool('M67TrooperSlaughter'))
		{
			count = 0;

			// count the living
			foreach AllActors(class'XVATroop', XVATroop)
				count++;

			foreach AllActors(class'XVAEnforcer', XVAEnforcer)
				count++;

			foreach AllActors(class'XVAOfficer', XVAOfficer)
				count++;

			if (count < 2)
				flags.SetBool('M67TrooperSlaughter', True,, 68);
		}
		if (flags.GetBool('AlexiaNovikova_Dead') && flags.GetBool('M67IlluminatiMissileLaunched') && flags.GetBool('M67IlluminatiSDUGoal') && !flags.GetBool('IllumiHandled3'))
		{
			Player.StartDataLinkTransmission("DL_M67_IlluminatiVictory");
			flags.SetBool('IllumiHandled3', True,, 68);
		}
		if (flags.GetBool('AlexiaNovikova_Dead') && !flags.GetBool('XVADeadSE'))
		{
			foreach AllActors(class'AlexiaNovikova', AlexiaNovikova)
				AlexiaNovikova.Destroy();
			Player.GoalCompleted('XVAVisitSDU');
			Player.GoalCompleted('XVANukes');
			Player.GoalCompleted('XVAObservation');
			flags.SetBool('XVADeadSE', True,, 68);
		}
		if (flags.GetBool('M67XVAEnding') &&
			!flags.GetBool('XVAFinalInfoLink'))
		{
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
					foreach AllActors(class'Actor', A, 'XVAVictoireTrigger')
					A.Trigger(Self, Player);
			player.PlaySound(sound'RocketIgnite', SLOT_None, 2.0,, 2048);
			Player.StartDataLinkTransmission("DL_M67XVA_Reactions");
			ShakeEffects();
			Player.GoalCompleted('XVANukes');
			Player.GoalCompleted('IlluminatiWarheads');
			Player.GoalCompleted('IlluminatiNovikova');
			Player.GoalCompleted('IlluminatiSDU');
			Player.GoalCompleted('SacrificeGoal');
			Player.GoalCompleted('M67MeetNrOne');
			Player.GoalCompleted('MJ12Killswitch');
			Player.GoalCompleted('MJ12Aquinas');
			foreach AllActors(class'XVAOfficer', XVAOfficer)
				XVAOfficer.bInvincible = True;
			foreach AllActors(class'XVATroop', XVATroop)
				XVATroop.bInvincible = True;
			foreach AllActors(class'XVAEnforcer', XVAEnforcer)
				XVAEnforcer.bInvincible = True;
			flags.SetBool('XVAFinalInfoLink', True,, 69);
		}
		if (flags.GetBool('M67IlluminatiEnding') &&
			!flags.GetBool('ZavichFinalInfoLink'))
		{
			Player.StartDataLinkTransmission("DL_M67Illuminati_NrOne");
			player.PlaySound(sound'RocketIgnite', SLOT_None, 2.0,, 2048);
			ShakeEffects();
			Player.GoalCompleted('IlluminatiWarheads');
			Player.GoalCompleted('SacrificeGoal');
			Player.GoalCompleted('XVAVisitSDU');
			Player.GoalCompleted('XVANukes');
			Player.GoalCompleted('XVAObservation');
			Player.GoalCompleted('M67MeetNrOne');
			Player.GoalCompleted('MJ12Killswitch');
			Player.GoalCompleted('MJ12Aquinas');
			flags.SetBool('ZavichFinalInfoLink', True,, 69);
		}
		if (flags.GetBool('M67SacrificeEnding') &&
			!flags.GetBool('OutrageInfoLink'))
		{
			foreach AllActors(class'Actor', A, 'M67SiloControlDoor')
			A.Trigger(Self, Player);
			player.PlaySound(sound'RocketIgnite', SLOT_None, 2.0,, 2048);
			Player.StartDataLinkTransmission("DL_M67Sacrifice");
			ShakeEffects();
			Player.GoalCompleted('IlluminatiWarheads');
			Player.GoalCompleted('IlluminatiNovikova');
			Player.GoalCompleted('IlluminatiSDU');
			Player.GoalCompleted('SacrificeGoal');
			Player.GoalCompleted('XVAVisitSDU');
			Player.GoalCompleted('XVANukes');
			Player.GoalCompleted('XVAObservation');
			Player.GoalCompleted('M67MeetNrOne');
			Player.GoalCompleted('MJ12Killswitch');
			Player.GoalCompleted('MJ12Aquinas');
			flags.SetBool('OutrageInfoLink', True,, 69);
		}

		if (flags.GetBool('M67MJ12Ending') && !flags.GetBool('TheStuff2254'))
		{
					foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
			flags.SetBool('TheStuff2254', True,, 69);
		}


	}
}

// ----------------------------------------------------------------------

function ShakeEffects()
{
	local float shakeTime, shakeRoll, shakeVert;
	local float size;
	local int i;
	local Vector bobble, loc, endloc, HitLocation, HitNormal;
	local MetalFragment frag;

	// pick a random explosion size and modify everything accordingly
	size = 0.5 * FRand() + 0.5;
	shakeTime = 0.5 + size;
	shakeRoll = 512.0 + 1024.0 * size;
	shakeVert = 8.0 + 16.0 * size;

	// play a sound
	if (size < 0.75)
		Player.PlaySound(Sound'MediumExplosion2', SLOT_None, 2.0,, 16384);
	else if (size < 0.85)
		Player.PlaySound(Sound'LargeExplosion1', SLOT_None, 2.0,, 16384);
	else
		Player.PlaySound(Sound'LargeExplosion2', SLOT_None, 2.0,, 16384);

	// shake the view
	Player.ShakeView(shakeTime, shakeRoll, shakeVert);

	// bobble the player around
	bobble = vect(300.0,300.0,200.0) + 500.0 * size * VRand();
	Player.Velocity += bobble;

}

// ----------------------------------------------------------------------





defaultproperties
{
}
