//=============================================================================
// EthanYoon.
//=============================================================================
class EthanYoon expands HumanThug;

//
// Damage type table for Ethan Yoon:
//
// Shot			- 100%
// Sabot		- 100%
// Exploded		- 100%
// TearGas		- 10%
// PoisonGas	- 10%
// Poison		- 10%
// PoisonEffect	- 10%
// HalonGas		- 10%
// Radiation	- 10%
// Shocked		- 10%
// Stunned		- 0%
// KnockedOut   - 0%
// Flamed		- 0%
// Burned		- 0%
// NanoVirus	- 0%
// EMP			- 0%
//

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ((damageType == 'Flamed') || (damageType == 'Burned') || (damageType == 'Stunned') ||
	    (damageType == 'KnockedOut'))
		return 0.5;
	else if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas') ||
			(damageType == 'Radiation') || (damageType == 'Shocked') || (damageType == 'Poison') ||
	        (damageType == 'PoisonEffect'))
		return 0.1;
	else
		return Super.ShieldDamage(damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}


defaultproperties
{
     CarcassType=Class'fgrhk.EthanYoonCarcass'
     bImportant=True
     CloseCombatMult=0.500000
     BaseAssHeight=-23.000000
     BurnPeriod=0.000000
     bHasCloak=True
     CloakThreshold=150
     walkAnimMult=1.400000
     GroundSpeed=240.000000
     Health=350
     HealthHead=350
     HealthTorso=350
     HealthLegLeft=350
     HealthLegRight=350
     HealthArmLeft=350
     HealthArmRight=350
     WalkingSpeed=0.333333
     WalkSound=Sound'DeusExSounds.Robot.SecurityBot2Walk'
     InitialInventory(0)=(Inventory=Class'DeusEx.WeaponPlasmaRifle')
     InitialInventory(1)=(Inventory=Class'DeusEx.WeaponAssaultGun')
     InitialInventory(2)=(Inventory=Class'DeusEx.WeaponPistol')
     InitialInventory(3)=(Inventory=Class'DeusEx.AmmoPlasma',Count=2)
     InitialInventory(4)=(Inventory=Class'DeusEx.Ammo762mm',Count=2)
     Mesh=LodMesh'DeusExCharacters.GM_Trench'
     MultiSkins(0)=Texture'fgrhk.Skins.EthanYoonTex0'
     MultiSkins(1)=Texture'fgrhk.Skins.EthanYoonTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.PantsTex9'
     MultiSkins(3)=Texture'fgrhk.Skins.EthanYoonTex1'
     MultiSkins(4)=Texture'fgrhk.Skins.EthanYoonTex1'
     MultiSkins(5)=Texture'fgrhk.Skins.EthanYoonTex2'
     MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="EthanYoon"
     FamiliarName="Ethan Yoon"
     UnfamiliarName="Ethan Yoon"
}
