//=============================================================================
// FlagPole.
//=============================================================================
class FlagPole2 extends DeusExDecoration;

#exec mesh IMPORT MESH=DXNHDFlagPole ANIVFILE=MODELS\HDTPFlagPole_a.3d DATAFILE=MODELS\HDTPFlagPole_d.3d X=0 Y=0 Z=0 Unmirror=1
#exec mesh ORIGIN MESH=DXNHDFlagPole X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=DXNHDFlagPole SEQ=All  STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=DXNHDFlagPole SEQ=still STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=DXNHDFlagPoleTex1 FILE=Textures\HDPole_china.PCX GROUP=Skins // MATERIAL
#exec texture IMPORT NAME=DXNHDFlagPoleTex3 FILE=Textures\HDPole_PRES.PCX GROUP=Skins // MATERIAL
#exec texture IMPORT NAME=DXNHDFlagPoleTex5 FILE=Textures\HDPole_US.PCX GROUP=Skins // MATERIAL

#exec MESHMAP new   MESHMAP=DXNHDFlagPole MESH=DXNHDFlagPole
#exec MESHMAP scale MESHMAP=DXNHDFlagPole X=0.0048828125 Y=0.0048828125 Z=0.0048828125

#exec MESHMAP SETTEXTURE MESHMAP=DXNHDFlagPole NUM=1 TEXTURE=DXNHDFlagPoleTex1
//#exec MESHMAP SETTEXTURE MESHMAP=Flag NUM=1 TEXTURE=FlagPoleTex1

enum ESkinColor
{
	SC_China,
	SC_France,
	SC_President,
	SC_UNATCO,
	SC_USA
};

var() travel ESkinColor SkinColor;

// ----------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------

function BeginPlay()
{
	Super.BeginPlay();

	SetSkin();
}

// ----------------------------------------------------------------------
// TravelPostAccept()
// ----------------------------------------------------------------------

function TravelPostAccept()
{
	Super.TravelPostAccept();

	SetSkin();
}

// ----------------------------------------------------------------------
// SetSkin()
// ----------------------------------------------------------------------

function SetSkin()
{
	switch (SkinColor)
	{
		case SC_China:		Skin = Texture'fgrhk.Skins.DXNHDFlagPoleTex1'; break;
		case SC_France:		Skin = Texture'FlagPoleTex2'; break;
		case SC_President:	Skin = Texture'fgrhk.Skins.DXNHDFlagPoleTex3'; break;
		case SC_UNATCO:		Skin = Texture'FlagPoleTex4'; break;
		case SC_USA:		Skin = Texture'fgrhk.Skins.DXNHDFlagPoleTex5'; break;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     FragType=Class'DeusEx.WoodFragment'
     ItemName="Flag Pole"
     Mesh=LodMesh'fgrhk.DXNHDFlagPole'
     CollisionRadius=17.000000
     CollisionHeight=56.389999
     Mass=40.000000
     Buoyancy=30.000000
}
