//=============================================
// HKMission60Script.
//=============================================
class HKMission60Script expands MissionScript;

function InitStateMachine() 
{

    super.InitStateMachine();
    FirstFrame();

}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{

	local TriadRedArrow RedArro;
	local TriadLumPath LumPath1;
	local TriadLumPath2 LumPath12;

	if (localURL == "60_HONGKONG_GREASELPIT")
	{
		if (flags.GetBool('M60PitFightOver') && !flags.Getbool('GoHomeTriad'))
		{
				foreach AllActors(class'TriadRedArrow', RedArro)
				RedArro.LeaveWorld();
				foreach AllActors(class'TriadLumPath', LumPath1)
				LumPath1.LeaveWorld();
				foreach AllActors(class'TriadLumPath2', LumPath12)
				LumPath12.LeaveWorld();
				flags.setbool('GoHomeTriad',true,, 62);
		}
		if (flags.GetBool('M60GreaselCrisis') && !flags.Getbool('GoHomeTriad'))
		{
				foreach AllActors(class'TriadRedArrow', RedArro)
				RedArro.LeaveWorld();
				foreach AllActors(class'TriadLumPath', LumPath1)
				LumPath1.LeaveWorld();
				foreach AllActors(class'TriadLumPath2', LumPath12)
				LumPath12.LeaveWorld();
				flags.setbool('GoHomeTriad',true,, 62);
		}
	}

		Super.PreTravel();
}

function firstframe()
{

	local float rnd;
	local float rnd2;
	local ScriptedPawn P;
	local Greasel G;
	local Animal Animal;

 	local Inventory itemToAdd, item, nextItem;

	Super.FirstFrame();

	if (localURL == "60_HONGKONG_GREASELPIT")
	{
		if (!flags.GetBool('M60GreaselHealth'))
		{
			foreach AllActors(class'Greasel', G, 'GreaselRA')
			{
			rnd = FRand();

			if (rnd < 0.33)
			{
				G.Health=85;
					foreach AllActors(class'Animal', Animal, 'GreaselLP')
					{
					Animal.Health=100;
					}
				flags.setbool('M60GreaselHealth',true,, 62);
			}
			else if (rnd < 0.66)
			{
				G.Health=100;
					foreach AllActors(class'Animal', Animal, 'GreaselLP')
					{
					Animal.Health=85;
					}
				flags.setbool('M60GreaselHealth',true,, 62);
			}
			else
			{
				G.Health=100;
					foreach AllActors(class'Animal', Animal, 'GreaselLP')
					{
					Animal.Health=100;
					}
				flags.setbool('M60GreaselHealth',true,, 62);
			}
			}
		}

	}

   	if (localURL == "60_HONGKONG_STREETS")
   	{
		if (!flags.GetBool('M60_OpenAB'))
		{
			Player.StartDataLinkTransmission("DL_HK60_ZavichIntro");
			flags.SetBool('M60_OpenAB', True,, 62);
		}
	}


   	if (localURL == "60_HONGKONG_MPSHELIPAD")
   	{

	if (!flags.GetBool('M60_InventoryRemoved'))
		{
			RemoveAllInventory();
			flags.SetBool('M60_InventoryRemoved', True,, 70);
		}
	}

}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{

	local Yakedo Yake;
	local ScriptedPawn P;
	local SpawnPoint SP;
	local Actor A;
	local DeusExMover M;
	local MedicalBot MedicalBot;
	local RepairBot RepairBot;
	local HumanThuG T;
	local TriadLumPathCarcass carc;
	local TriadRedArrowCarcass redcarc;
	local HKCopCarcass copcarc;
	local int count;
	local MIDouble MIDouble;
	local Janitor Janitor;
	local HKCop HKCop;
	local GreaselCarcass greasecarc;
	local Greasel G;
	local Animal Animal;
	local RatCarcass KakaRatto;
	local TriadRedArrow RedoArro;
	local AlarmUnit unit;
	local SecurityCamera cam;
	local HumanCivilian HumanCivilian;
	local AutoTurret turret;

	Super.Timer();

   	if (localURL == "60_HONGKONG_MPSHQ")
   	{

		if (flags.GetBool('MeetTheDirector_Played') && !flags.GetBool('SlartiMove'))
		{
			foreach AllActors(class'Actor', A, 'DirectorVouz')
				A.Trigger(Self, Player);
			flags.SetBool('SlartiMove', True,, 62);
		}

		if (flags.GetBool('MeetKateMPS_Played') && !flags.GetBool('June12Move'))
		{
			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'doorietta0'))
				{
					M.bFrobbable = True;
					M.bHighLight = True;
					M.bLocked = False;
					flags.SetBool('June12Move', True,, 62);
				}
			}
		}

	}

	if (localURL == "60_HONGKONG_GREASELPIT")
	{

		if (flags.GetBool('SneakeDicke') && !flags.GetBool('M60GreaselFight'))
		{
			foreach AllActors(class'Actor', A, 'SnakeTrigger')
				A.Trigger(Self, Player);
		}
		if (flags.GetBool('SneakeDicke') && !flags.GetBool('M60PitFightOver'))
		{
			foreach AllActors(class'Actor', A, 'SnakeTrigger')
				A.Trigger(Self, Player);
		}
		if (flags.GetBool('SneakeDicke') && !flags.GetBool('M60GreaselCrisis'))
		{
			foreach AllActors(class'Actor', A, 'SnakeTrigger')
				A.Trigger(Self, Player);
		}

		if (flags.GetBool('M60GreaselCrisis') && !flags.GetBool('NothingPromisedNoRegrets'))
		{
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "PitBetty")
			{
			P.LeaveWorld();
			flags.setbool('NothingPromisedNoRegrets',true,, 62);
			}
			}
		}

		if (flags.GetBool('M60GreaselCrisis') && !flags.GetBool('NothingPromisedNoRegrets5A'))
		{
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "TriadSnitch")
			{
			P.LeaveWorld();
			flags.setbool('NothingPromisedNoRegrets5A',true,, 62);
			}
			}
		}

		if (flags.GetBool('M60GreaselCameras') && !flags.GetBool('CameraEasy'))
		{
				foreach AllActors(class'SecurityCamera', cam)
						cam.bNoAlarm = True;
				foreach AllActors(class'AutoTurret', turret)
					turret.bActive = False;
			flags.setbool('CameraEasy',true,, 62);
		}

		if (flags.GetBool('TalkedToCafeCops') && !flags.GetBool('M60GreaselFight') && !flags.GetBool('JumpForMyLoaf'))
		{
			flags.setbool('M60GreaselCops',true,, 62);
			flags.setbool('M60GreaselCameras',true,, 62);
				foreach AllActors(class'HumanThuG', T)
						T.LeaveWorld();
				foreach AllActors(class'HumanCivilian', HumanCivilian)
						HumanCivilian.LeaveWorld();
				foreach AllActors(class'Animal', Animal)
						Animal.LeaveWorld();
			flags.setbool('JumpForMyLoaf',true,, 62);
		}


		if (flags.GetBool('GreaselLP_Dead') && !flags.GetBool('M60GreaselFight') && !flags.GetBool('TimeRuiner1'))
		{
				foreach AllActors(class'AlarmUnit', unit, 'AlarmUnit')
					unit.Trigger(None, None);
			flags.setbool('GreaselUltimateStatus',true,, 62);
			flags.setbool('TimeRuiner1',true,, 62);
		}

		if (flags.GetBool('GreaselRA_Dead') && !flags.GetBool('M60GreaselFight') && !flags.GetBool('TimeRuiner1'))
		{
				foreach AllActors(class'AlarmUnit', unit, 'AlarmUnit')
					unit.Trigger(None, None);
			flags.setbool('GreaselUltimateStatus',true,, 62);
			flags.setbool('TimeRuiner1',true,, 62);
		}


		if (flags.GetBool('LPGRGone') && !flags.GetBool('MotlurFlg1'))
		{
					foreach AllActors(class'Animal', Animal, 'GreaselLP')
					{
					Animal.LeaveWorld();
			foreach AllActors(class'Actor', A, 'NoLPPointsF')
				A.Trigger(Self, Player);
					flags.SetBool('MotlurFlg1', True,, 62);
					}
		}
		if (flags.GetBool('RAGRGone') && !flags.GetBool('MotlurFlg111'))
		{
					foreach AllActors(class'Animal', Animal, 'GreaselRA')
					{
					Animal.LeaveWorld();
			foreach AllActors(class'Actor', A, 'NoRAPointsF')
				A.Trigger(Self, Player);
					flags.SetBool('MotlurFlg111', True,, 62);
					}
		}

		if (flags.GetBool('SnitchDoorFlag') && !flags.GetBool('MotlarFlg12'))
		{
			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'SnitchDoor'))
				{
					M.bLocked = False;
					flags.setbool('MotlarFlg12',true,, 62);
				}
			}
		}

		if (flags.GetBool('TriadSnitch_dead') && !flags.GetBool('MotlarFlg15'))
		{
			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'SnitchDoor'))
				{
					M.bLocked = False;
					flags.setbool('MotlarFlg15',true,, 62);
				}
			}
		}

		if (flags.GetBool('EnterRaRat') && !flags.GetBool('EnterBorat1'))
		{
		foreach AllActors(class'RatCarcass', KakaRatto, 'DestinyRat')
			{
					SP = GetSpawnPoint('RASpawnPoint');
					if (SP != None)
					{
							KakaRatto.SetLocation(SP.Location);
							KakaRatto.SetRotation(SP.Rotation);
							flags.setbool('EnterBorat1',true,, 62);
					}
			}
		}

		if (flags.GetBool('EnterLuRat') && !flags.GetBool('EnterBorat12'))
		{
		foreach AllActors(class'RatCarcass', KakaRatto, 'DestinyRat')
			{
					SP = GetSpawnPoint('LPSpawnPoint');
					if (SP != None)
					{
							KakaRatto.SetLocation(SP.Location);
							KakaRatto.SetRotation(SP.Rotation);
							flags.setbool('EnterBorat12',true,, 62);
					}
			}
		}



		if (flags.GetBool('GreaselUltimateStatus') && !flags.GetBool('M60GreaselFight') && !flags.GetBool('MiscM60Bertie35'))
		{
			flags.setbool('M60GreaselTriadFlare',true,, 62);
			flags.setbool('M60GreaselCrisis',true,, 62);
			flags.setbool('MiscM60Bertie35',true,, 62);
		}

		if (flags.GetBool('M60GreaselCops') && !flags.GetBool('MiscM60Bertie'))
		{
			foreach AllActors(class'HKCop', HKCop)
			HKCop.EnterWorld();
			foreach AllActors(class'Actor', A, 'CopPatrols')
				A.Trigger(Self, Player);
			flags.setbool('MiscM60Bertie',true,, 62);
		}


		if (flags.GetBool('M60GreaselTriadFlare') && !flags.GetBool('Greaseltown'))
		{
			foreach AllActors(class'Actor', A, 'GuardNice')
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'PitTriadFight')
				A.Trigger(Self, Player);
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "PitBetty")
			{
			P.LeaveWorld();
			}
			}
			flags.setbool('M60SnitchRunsHeRuns',true,, 62);
			foreach AllActors(class'Actor', A, 'SnitchRunSnitch')
				A.Trigger(Self, Player);
			foreach AllActors(class'TriadRedArrow', RedoArro, 'RedoArro')
			RedoArro.EnterWorld();
			flags.setbool('MeetTheTenkaichi_played',true,, 62);
			flags.setbool('Greaseltown',true,, 62);
		}

		if (flags.GetBool('M60PitFightOver') && !flags.GetBool('PostFightSnitch'))
		{
			if (flags.GetBool('M60RedGreaselWins'))
			{
			flags.setbool('M60SnitchClear',true,, 62);
			flags.setbool('M60GreaselCameras',true,, 62);
			flags.setbool('PostFightSnitch',true,, 62);
			}
			else
			{
			flags.setbool('M60SnitchRunsHeRuns',true,, 62);
			foreach AllActors(class'Actor', A, 'SnitchRunSnitch')
				A.Trigger(Self, Player);
			foreach AllActors(class'TriadRedArrow', RedoArro, 'RedoArro')
			RedoArro.EnterWorld();
			foreach AllActors(class'Actor', A, 'GuardNice')
				A.Trigger(Self, Player);
			flags.setbool('M60GreaselCameras',true,, 62);
			flags.setbool('PostFightSnitch',true,, 62);
			}
		}



		if (flags.GetBool('M60GreaselFight') && flags.GetBool('M60LPGreaselPoisoned') && !flags.GetBool('Poison1Done'))
		{
					foreach AllActors(class'Animal', Animal, 'GreaselLP')
					{
					Animal.TakeDamage(12, Animal, Animal.Location, vect(0,0,0), 'Poison');
					}
					flags.setbool('Poison1Done',true,, 62);
		}
		if (flags.GetBool('M60GreaselFight') && flags.GetBool('M60RAGreaselPoisoned') && !flags.GetBool('Poison1Done'))
		{
					foreach AllActors(class'Greasel', G, 'GreaselRA')
					{
					G.TakeDamage(12, G, G.Location, vect(0,0,0), 'Poison');
					}
					flags.setbool('Poison1Done',true,, 62);
		}

		if (flags.GetBool('GreaselLP_Dead') && !flags.GetBool('GreaselRA_Dead') && flags.GetBool('M60GreaselFight') && !flags.GetBool('M60GreaselSituation1'))
		{
				flags.setbool('M60RedGreaselWins',true,, 62);
				flags.setbool('M60PitFightOver',true,, 62);
				flags.setbool('M60GreaselSituation1',true,, 62);
		}
		if (!flags.GetBool('GreaselLP_Dead') && flags.GetBool('GreaselRA_Dead') && flags.GetBool('M60GreaselFight') && !flags.GetBool('M60GreaselSituation1'))
		{
				flags.setbool('M60LuminousGreaselWins',true,, 62);
				flags.setbool('M60PitFightOver',true,, 62);
				flags.setbool('M60GreaselSituation1',true,, 62);
		}

		if (flags.GetBool('GreaselLP_Dead') && flags.GetBool('GreaselRA_Dead') && flags.GetBool('M60GreaselFight') && !flags.GetBool('M60GreaselSituation1'))
		{
				flags.setbool('M60GreaselTie',true,, 62);
				flags.setbool('M60PitFightOver',true,, 62);
				flags.setbool('M60GreaselSituation1',true,, 62);
		}

		// This section contains a bunch of repetitive flags
		// This section contains a bunch of repetitive flags
		// This section contains a bunch of repetitive flags
		// This section contains a bunch of repetitive flags

		if (flags.GetBool('LuminousJackpot') && flags.GetBool('PitLP100') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Pit100CreditsT')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('RedArrowJackpot') && flags.GetBool('PitRA100') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Pit100CreditsT')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('LuminousJackpot') && flags.GetBool('PitLP500') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Pit500CreditsT')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('RedArrowJackpot') && flags.GetBool('PitRA500') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Pit500CreditsT')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('LuminousJackpot') && flags.GetBool('PitLP1000') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Pit1000CreditsT')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('RedArrowJackpot') && flags.GetBool('PitRA1000') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Pit1000CreditsT')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}

		if (flags.GetBool('BettyTieAcquired') && flags.GetBool('PitLP100') && flags.GetBool('M60GreaselTie') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Refund100')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('BettyTieAcquired') && flags.GetBool('PitRA100') && flags.GetBool('M60GreaselTie') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Refund100')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('BettyTieAcquired') && flags.GetBool('PitLP500') && flags.GetBool('M60GreaselTie') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Refund500')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('BettyTieAcquired') && flags.GetBool('PitRA500') && flags.GetBool('M60GreaselTie') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Refund500')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('BettyTieAcquired') && flags.GetBool('PitLP1000') && flags.GetBool('M60GreaselTie') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Refund1000')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}
		if (flags.GetBool('BettyTieAcquired') && flags.GetBool('PitRA1000') && flags.GetBool('M60GreaselTie') && !flags.GetBool('M60NoMoreBets'))
		{
			foreach AllActors(class'Actor', A, 'Refund1000')
				A.Trigger(Self, Player);
					flags.setbool('M60NoMoreBets',true,, 62);
		}

		// This section contains a bunch of repetitive flags
		// This section contains a bunch of repetitive flags
		// This section contains a bunch of repetitive flags
		// This section contains a bunch of repetitive flags

	}

	if (localURL == "60_HONGKONG_STREETS")
	{
		if (flags.GetBool('DatPrisoner_Dead') && flags.GetBool('MeetDatGuy_Played') && flags.GetBool('YakedoBoat_Played') && flags.GetBool('IngramDickinsonY') && flags.GetBool('YakedoHatesIngram') && flags.GetBool('IngramKnowsTakaraFamily') && !flags.getbool('CountryManHere'))
		{
			Player.StartDataLinkTransmission("DL_HK60NEW_IngramFails");
			flags.SetBool('CountryManHere', True,, 62);
		}

		if (flags.GetBool('M60PitFightOver') && flags.GetBool('M60RedGreaselWins') && flags.GetBool('M60LPGreaselPoisoned') && !flags.GetBool('M60RedSnarrow') && !flags.GetBool('MiscM6XCDS25'))
		{
			foreach AllActors(class'ScriptedPawn', P, 'M60RedMeeter')
				P.EnterWorld();

			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'Engstrome1722'))
				{
					M.bLocked = False;
				}
			}

			foreach AllActors(class'ScriptedPawn', P, 'CafeCop')
				P.LeaveWorld();

			flags.setbool('MiscM6XCDS25',true,, 62);
		}

		if (flags.GetBool('M60PitFightOver') && flags.GetBool('M60LuminousGreaselWins') && flags.GetBool('M60RAGreaselPoisoned') && !flags.GetBool('M60LumParrow') && !flags.GetBool('MiscM6XCDS27'))
		{

			foreach AllActors(class'ScriptedPawn', P, 'CafeCop')
				P.LeaveWorld();
			foreach AllActors(class'ScriptedPawn', P, 'M60LumMeeter')
				P.EnterWorld();
			flags.setbool('MiscM6XCDS27',true,, 62);
		}

		if (!flags.GetBool('M60LumPathEnemy'))
		{
			count = 0;

			foreach AllActors(class'TriadLumPathCarcass', carc)
			{
				if ((carc.KillerBindName == "MadIngram") && (carc.itemName == "Unconscious"))
					count++;
				else if (carc.KillerBindName != "MadIngram")
					count++;
			}

			// if the player killed more than 5, set the flag
			if (count > 5)
				flags.SetBool('LuminousPathAlliance', False,, 0);
				flags.SetBool('M60LumPathEnemy', True,, 0);
		}

		if (!flags.GetBool('M60RedArrowEnemy'))
		{
			count = 0;

			foreach AllActors(class'TriadRedArrowCarcass', redcarc)
			{
				if ((redcarc.KillerBindName == "MadIngram") && (redcarc.itemName == "Unconscious"))
					count++;
				else if (redcarc.KillerBindName != "MadIngram")
					count++;
			}

			// if the player killed more than 5, set the flag
			if (count > 5)
				flags.SetBool('RedArrowAlliance', False,, 0);
				flags.SetBool('M60RedArrowEnemy', True,, 0);	
		}

		if(flags.getbool('YoonBotheredEnd') && !flags.getbool('YakedoHasMoved'))
		{

			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'M60NewYakeDoorA25'))
				{
					M.bLocked = False;
				}
			}

			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "Yakedo")
					{
						SP = GetSpawnPoint('Yakeport');
						if (SP != None)
						{
							P.SetLocation(SP.Location);
							P.SetRotation(SP.Rotation);
							P.SetOrders('Standing',, True);
							P.SetHomeBase(SP.Location, SP.Rotation);
							flags.setbool('YakedoHasMoved',true);
						}
					}


					}
				}
			
		

		if(flags.getbool('IngramFengComputer') && !flags.getbool('MeetTheYoon_Played') && !flags.getbool('PreYoonFlag1'))
		{
			foreach AllActors(class'Actor', A, 'FengEncounter1D')
				A.Trigger(Self, Player);
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "VicFeng")
					{
						P.EnterWorld();
						SP = GetSpawnPoint('Fengport');
						if (SP != None)
						{
							P.SetLocation(SP.Location);
							P.SetRotation(SP.Rotation);
							P.SetOrders('Standing',, True);
							P.SetHomeBase(SP.Location, SP.Rotation);
						}
					}
				}
			flags.SetBool('PreYoonFlag1', True,, 62);
		}
		if(!flags.getbool('M60YakedoVaultOpened'))
		{
			foreach AllActors(class'DeusExMover', M, 'YakedoVault1')
				if (M.bDestroyed)
					flags.setbool('M60YakedoVaultOpened',true,, 62);

		}
		if(!flags.getbool('M60YakedoVaultOpened'))
		{
			foreach AllActors(class'DeusExMover', M, 'YakedoVault2')
				if (M.bDestroyed)
					flags.setbool('M60YakedoVaultOpened',true,, 62);

		}
		if(flags.getbool('M60YakedoVaultOpened') && !flags.getbool('YoonBotheredEnd') && !flags.GetBool('M60Yakedork1'))
		{
				flags.setbool('YakedoHatesIngram',true,, 68);
				Player.StartDataLinkTransmission("DL_HK60_YakedoHate");

			foreach AllActors(class'MedicalBot', MedicalBot, 'MedicalBot')
				MedicalBot.GotoState('Disabled');
				MedicalBot.SoundVolume = 0;

			foreach AllActors(class'RepairBot', RepairBot, 'YDRepairBot')
				RepairBot.GotoState('Disabled');
				RepairBot.SoundVolume = 0;

				flags.setbool('M60Yakedork1',true,, 62);

		}

	}

	if (localURL == "60_HONGKONG_STREETS")
	{

		if(flags.GetBool('YoonTalkingHeads') && !flags.GetBool('Handlings213'))
		{
			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'frontdoors00404'))
				{
					if (M.KeyNum == 0)
						M.Trigger(None, None);
				flags.setbool('PaidForForichi',true,, 62);
				flags.setbool('DoneWithYKTODAI',true,, 62);
				flags.setbool('Handlings213',true,, 62);
				}
			}
		}

		if(flags.getbool('MeetTheYoon_Played') && !flags.getbool('FengAppears'))
		{

			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "VicFeng")
			{
				P.EnterWorld();
				flags.setbool('FengAppears',true);
			}
			}
		}
		if(flags.getbool('VicFeng_Unconscious') && !flags.getbool('FengSpecialCase'))
		{

				flags.setbool('VicFeng_Dead',false,, 62);
				flags.setbool('FengTakenCareOf',true,, 62);
				flags.setbool('FengSpecialCase',true,, 62);
		}
		if(flags.getbool('VicFeng_Dead') && !flags.getbool('FengSpecialCase2'))
		{
				flags.setbool('FengTakenCareOf',true,, 62);
				flags.setbool('FengSpecialCase2',true,, 62);
		}
		if(!flags.getbool('YakedoorGag'))
		{
			foreach AllActors(class'DeusExMover', M, 'YakedoPersonalDoor')
				if (M.bDestroyed)
				flags.setbool('YakedoorGag',true,, 62);
		}
		if (flags.GetBool('FGRHKAugsRetrieved') && !flags.getbool('M60AugaMauga'))
		{
			Player.StartDataLinkTransmission("DL_HK60_AugsDiscovered");
			flags.SetBool('M60AugaMauga', True,, 62);
		}
		if(flags.GetBool('YakedoHatesIngram') && flags.getbool('YakedoBoat_Played') && !flags.getbool('M60Misc19A'))
		{
			foreach AllActors(class'Actor', A, 'M60YoonMachina')
				A.Trigger(Self, Player);
				flags.setbool('M60Misc19A',true,, 62);
		}
		if (flags.GetBool('StreetHoodoo99') && !flags.getbool('StreetHoodoo98'))
		{
			Player.StartDataLinkTransmission("DL_HK60_YoonExMachina");
			flags.SetBool('StreetHoodoo98', True,, 62);
		}
		if(flags.getbool('IngramAskedNo1') && flags.getbool('IngramAskedNo3')  && flags.getbool('IngramAskedNo4') && !flags.getbool('ConvoDoneYakedo'))
		{
				flags.setbool('ConvoDoneYakedo',true,, 62);
		}
	}
	
	if (localURL == "60_HONGKONG_FORICHI")
	{
		if (flags.GetBool('GreaselPitAwareness') && !flags.GetBool('FromSnowhereM60A1'))
		{
			foreach AllActors(class'ScriptedPawn', P, 'ForichiCopGreasy')
			P.EnterWorld();
			flags.SetBool('FromSnowhereM60A1', True,, 62);
		}
		if (flags.GetBool('NewZavichLineFlag') && !flags.getbool('StreetHoodoo98001'))
		{
			Player.StartDataLinkTransmission("DL_HK60_GoToTuenMun");
			flags.SetBool('StreetHoodoo98001', True,, 62);
		}
		if(!flags.GetBool('M60Win2Broke'))
		{
			foreach AllActors(class'DeusExMover', M, 'PolizeiStorageGlass')
				{
				if (M.bDestroyed)
				flags.setbool('M60Win2Broke',true,, 62);
				}
		}

		if(flags.GetBool('MingGuardsMove') && flags.getbool('ToiletPath_Dead') && flags.getbool('MingSpotOn') && !flags.getbool('MingFail') && !flags.getbool('ForichiGreasey'))
		{
				flags.setbool('MingIsOver',true,, 62);
				flags.setbool('MingSuccess',true,, 62);
				flags.setbool('ForichiGreasey',true,, 62);
		}
		if(flags.GetBool('MingSuccess') && !flags.getbool('ForichiHoodoo40AB'))
		{
			foreach AllActors(class'Actor', A, 'MingSteps')
				A.Trigger(Self, Player);
				flags.setbool('ForichiHoodoo40AB',true,, 62);
		}
		if(flags.GetBool('ToiletGreasel_Played') && !flags.GetBool('ToiletPath_Dead') && !flags.getbool('ForichiHoodoo50AB'))
		{
				flags.setbool('MingIsOver',true,, 62);
				flags.setbool('MingFail',true,, 62);
			foreach AllActors(class'Actor', A, 'MingSteps')
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'GuardsGoBackMing')
				A.Trigger(Self, Player);
				flags.setbool('ForichiHoodoo50AB',true,, 62);
		}

		if (flags.GetBool('M60GreaselCops') && !flags.GetBool('M60HandlerGC1'))
		{
			foreach AllActors(class'ScriptedPawn', P)
			{
				if ((P.Tag == 'ForichiCop1') || (P.Tag == 'ForichiCop12') || (P.Tag == 'ForichiCop13') || (P.Tag == 'ForichiCop14') || (P.Tag == 'ForichiCopGreasy'))
				{
					P.LeaveWorld();
				}
			}
			flags.setbool('M60HandlerGC1',true,, 62);
		}



		if (!flags.GetBool('M60PlayerAggressive'))
		{
			count = 0;

			// count the living
			foreach AllActors(class'HKCop', HKCop)
				count++;

			// add the unconscious ones to the not dead count
			// there are 28 terrorists total on the island
			foreach AllActors(class'HKCopCarcass', copcarc)
			{
				if ((copcarc.KillerBindName == "MadIngram") && (copcarc.itemName == "Unconscious"))
					count++;
				else if (copcarc.KillerBindName != "MadIngram")
					count++;
			}

			// if the player killed more than 5, set the flag
			if (count < 8)
				flags.SetBool('M60PlayerAggressive', True,, 62);		// don't expire until mission 62
		}
		if(!flags.getbool('M60ForichiShopBreakIn'))
		{
			foreach AllActors(class'DeusExMover', M, 'M60ForichiShopDoors')
				if (M.bDestroyed)
				flags.setbool('M60ForichiShopBreakIn',true,, 62);
		}
		if(flags.GetBool('M60ForichiFrontEntry') && !flags.getbool('M60ForichiSneak') && !flags.getbool('ForichiHoodoo'))
		{
				flags.setbool('IngramEntersFCFront',true,, 62);
				flags.setbool('ForichiHoodoo',true,, 62);
		}
		if(!flags.GetBool('M60ForichiFrontEntry') && flags.getbool('M60ForichiSneak') && !flags.getbool('ForichiHoodoo'))
		{
				flags.setbool('IngramEntersFCBack',true,, 62);
				flags.setbool('ForichiHoodoo',true,, 62);
		}
		if(flags.GetBool('M60AlterCheckxit') && !flags.getbool('DatPrisonerHere') && !flags.getbool('ForichiHoodoo2'))
		{
				flags.setbool('M60AlterCheckxit',false,, 62);
		}
		if(flags.GetBool('M60AlterCheckxit') && flags.getbool('DatPrisonerHere') && !flags.getbool('ForichiHoodoo4'))
		{
			foreach AllActors(class'Actor', A, 'FirstAlterChecker')
				A.Trigger(Self, Player);
				flags.setbool('ForichiHoodoo4',true,, 62);
		}
		if(flags.GetBool('SecondFlagCrap') && !flags.getbool('DatPrisoner_Dead') && !flags.getbool('ForichiHoodoo5'))
		{
			foreach AllActors(class'Actor', A, 'M60SecondAlterChecker')
				A.Trigger(Self, Player);
				flags.setbool('ForichiHoodoo5',true,, 62);
		}
		if(flags.GetBool('M60MagicAppears') && flags.getbool('DatPrisonerHere') && !flags.getbool('ForichiHoodoo6'))
		{
			foreach AllActors(class'MIDouble', MIDouble)
				MIDouble.EnterWorld();
			foreach AllActors(class'ScriptedPawn', P)
			{
			if (P.BindName == "DatJanitor2")
			{
				P.EnterWorld();
			}
			}
			foreach AllActors(class'Actor', A, 'RunningRumba')
				A.Trigger(Self, Player);
			foreach AllActors(class'Actor', A, 'Domoroma')
				A.Trigger(Self, Player);

				flags.setbool('YumashevChopper',true,, 62);
				flags.setbool('ForichiHoodoo6',true,, 62);
		}
		if(flags.GetBool('YakedoHatesIngram') && flags.getbool('YakedoBoat_played') && !flags.getbool('ForichiHoodoo70'))
		{
				foreach AllActors(class'ScriptedPawn', P)
				{
					if (P.BindName == "M60CellTroop")
					{
						P.EnterWorld();
					}
				}
				foreach AllActors(class'ScriptedPawn', P)
				{
					if (P.BindName == "DatPrisoner")
					{
						P.EnterWorld();
					}
				}
			foreach AllActors(class'DeusExMover', M)
			{
				if ((M.Tag == 'M60ForichiNutsDoor') || (M.Tag == 'DatFrontDoor'))
				{
					if (M.KeyNum == 0)
						M.Trigger(None, None);
					M.bBreakable = True;
					M.bPickable = True;
					M.bFrobbable = True;
					M.bHighlight = True;
					M.bLocked = False;
				}
			}
				flags.setbool('ForichiHoodoo70',true,, 62);
		}
	}


}

function TeleportPawn(ScriptedPawn pawn, name patrolTag, name orders, optional bool bRandom)
{
	local PatrolPoint point;

	if (pawn != None)
	{
		point = GetPatrolPoint(patrolTag, bRandom);
		if (point != None)
		{
			pawn.SetLocation(point.Location);
			pawn.SetRotation(point.Rotation);
			pawn.SetOrders(orders,, True);
		}
	}
}

function RemoveAllInventory()
{
	local Inventory item, nextItem, lastItem;

	if (Player.Inventory != None)
	{
		item = Player.Inventory;
		nextItem = item.Inventory;
		lastItem = item;

		do
		{
			if ((item != None) && item.bDisplayableInv || item.IsA('Ammo'))
			{
				// make sure everything is turned off
				if (item.IsA('DeusExWeapon'))
				{
					DeusExWeapon(item).ScopeOff();
					DeusExWeapon(item).LaserOff();
				}
				if (item.IsA('DeusExPickup'))
				{
					if (DeusExPickup(item).bActive)
						DeusExPickup(item).Activate();
				}

   			if (item.IsA('ChargedPickup'))
					Player.RemoveChargedDisplay(ChargedPickup(item));

				Player.DeleteInventory(item);
				item.Destroy();
				item = Player.Inventory;
			}
			else
				item = nextItem;

			if (item != None)
				nextItem = item.Inventory;
		}
		until ((item == None) || (item == lastItem));
	}
}

defaultproperties
{
}
