//=============================================================================
// MacFarlane.
//=============================================================================
class MacFarlane extends HumanThug;

//
// Damage type table for Gunther Hermann:
//
// Shot			- 100%
// Sabot		- 100%
// Exploded		- 100%
// TearGas		- 10%
// PoisonGas	- 10%
// Poison		- 10%
// HalonGas		- 10%
// Radiation	- 10%
// Shocked		- 10%
// Stunned		- 0%
// KnockedOut   - 0%
// Flamed		- 0%
// Burned		- 0%
// NanoVirus	- 0%
// EMP			- 0%
//

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ((damageType == 'Burned') || (damageType == 'Stunned') ||
	    (damageType == 'KnockedOut'))
		return 0.0;
	else if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas') ||
			(damageType == 'Radiation') || (damageType == 'Shocked') || (damageType == 'Poison') ||
	        (damageType == 'PoisonEffect'))
		return 0.1;
	else
		return Super.ShieldDamage(damageType);
}


defaultproperties
{
     CarcassType=Class'fgrhk.MacFarlaneCarcass'
     WalkingSpeed=0.350000
     bImportant=True
     bInvincible=True
     CloseCombatMult=0.500000
     InitialInventory(0)=(Inventory=Class'fgrhk.WeaponM249DXN')
     InitialInventory(1)=(Inventory=Class'fgrhk.Ammo556DXN',Count=6)
     InitialInventory(2)=(Inventory=Class'DeusEx.WeaponCombatKnife')
     InitialInventory(3)=(Inventory=Class'DeusEx.WeaponFlamethrower')
     InitialInventory(4)=(Inventory=Class'DeusEx.AmmoNapalm',Count=6)
     BurnPeriod=0.000000
     walkAnimMult=0.750000
     GroundSpeed=300.000000
     BaseEyeHeight=44.000000
     Health=600
     HealthHead=600
     HealthTorso=600
     HealthLegLeft=600
     HealthLegRight=600
     HealthArmLeft=600
     HealthArmRight=600
     Texture=Texture'DeusExItems.Skins.BlackMaskTex'
     Mesh=LodMesh'DeusExCharacters.GM_DressShirt_B'
     DrawScale=1.100000
     MultiSkins(0)=Texture'fgrhk.Skins.Nov2Tex1'
     MultiSkins(1)=Texture'fgrhk.Skins.Nov2Tex2'
     MultiSkins(2)=Texture'fgrhk.Skins.Nov2Tex0'
     MultiSkins(3)=Texture'fgrhk.Skins.Nov2Tex0'
     MultiSkins(4)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(5)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(6)=Texture'DeusExItems.Skins.BlackMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     CollisionRadius=24.200001
     CollisionHeight=55.660000
     BindName="MacFarlane"
     FamiliarName="MacFarlane"
     UnfamiliarName="MacFarlane"
}
