//=============================================================================
// MadIngramMaleCarcass.
//=============================================================================
class MadIngramMaleCarcass extends DeusExCarcass;

// ----------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------

function PostPostBeginPlay()
{
	local DeusExPlayer player;

	Super.PostPostBeginPlay();

	foreach AllActors(class'DeusExPlayer', player)
		break;

	SetSkin(player);
}

// ----------------------------------------------------------------------
// SetSkin()
// ----------------------------------------------------------------------

function SetSkin(DeusExPlayer player)
{
	if (player != None)
	{
		switch(player.PlayerSkin)
		{
		case 0:	MultiSkins[1] = Texture'MadIngramTex2'; 
				MultiSkins[0] = Texture'WesleyCutterTex0';
				MultiSkins[3] = Texture'MadIngramTex1';
				MultiSkins[5] = Texture'MadIngramTex2';
				break;
		case 1:	MultiSkins[1] = Texture'MadIngramTex2'; 
				MultiSkins[0] = Texture'WesleyCutterTex01';
				MultiSkins[2] = Texture'MadIngramTex3';
				MultiSkins[3] = Texture'MadIngramTex12';
				MultiSkins[4] = Texture'MadIngramTex12';
				MultiSkins[5] = Texture'MadIngramTex2';
				break;
		case 2:	MultiSkins[1] = Texture'MadIngramTex14'; 
				MultiSkins[0] = Texture'WesleyCutterTex01';
				MultiSkins[2] = Texture'MadIngramTex32';
				MultiSkins[3] = Texture'MadIngramTex15';
				MultiSkins[4] = Texture'MadIngramTex15';
				MultiSkins[5] = Texture'MadIngramTex14';
 				MultiSkins[6] = Texture'FramesTex1';
 				MultiSkins[7] = Texture'LensesTex1';
				break;
		case 3:	MultiSkins[1] = Texture'JockTex2'; 
				MultiSkins[0] = Texture'WesleyCutterTex02';
				MultiSkins[2] = Texture'SoldierTex2';
				MultiSkins[3] = Texture'MadIngramTex13';
				MultiSkins[4] = Texture'MadIngramTex13';
				MultiSkins[5] = Texture'PinkMaskTex';
				break;
		case 4:	MultiSkins[1] = Texture'MadIngramTex10'; 
				MultiSkins[0] = Texture'WesleyCutterTex0';
				MultiSkins[3] = Texture'WesleyCutterTex0';
				MultiSkins[4] = Texture'MadIngramTex11';
				MultiSkins[5] = Texture'MadIngramTex10';
 				MultiSkins[6] = Texture'FramesTex3';
 				MultiSkins[7] = Texture'LensesTex7';
				break;
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     Mesh2=LodMesh'DeusExCharacters.GM_Trench_CarcassB'
     Mesh3=LodMesh'DeusExCharacters.GM_Trench_CarcassC'
     Mesh=LodMesh'DeusExCharacters.GM_Trench_Carcass'
     MultiSkins(0)=Texture'fgrhk.Skins.WesleyCutterTex0'
     MultiSkins(1)=Texture'fgrhk.Skins.MadIngramTex2'
     MultiSkins(2)=Texture'fgrhk.Skins.MadIngramTex3'
     MultiSkins(3)=Texture'fgrhk.Skins.MadIngramTex1'
     MultiSkins(4)=Texture'fgrhk.Skins.MadIngramTex1'
     MultiSkins(5)=Texture'fgrhk.Skins.MadIngramTex2'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex4'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex2'
     CollisionRadius=40.000000
}
