//=============================================================================
// WeaponSpiderGauss 
//=============================================================================
class WeaponSpiderGauss extends WeaponNPCRanged;

var ElectricityEmitter emitter;
var float zapTimer;
var vector lastHitLocation;
var int shockDamage;

// force EMP damage
function name WeaponDamageType()
{
	return 'EMP';
}

// fire weapons out of alternating sides
function Fire(float Value)
{
	PlayerViewOffset.Y = -PlayerViewOffset.Y;
	Super.Fire(Value);
}

// intercept the hit and turn on the emitter
function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);

	zapTimer = 0.5;
	if (emitter != None)
	{
		emitter.SetLocation(Owner.Location);
		emitter.SetRotation(Rotator(HitLocation - emitter.Location));
		emitter.TurnOn();
		emitter.SetBase(Owner);
		lastHitLocation = HitLocation;
	}
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	if (zapTimer > 0)
	{
		zapTimer -= deltaTime;

		// update the rotation of the emitter
		emitter.SetRotation(Rotator(lastHitLocation - emitter.Location));

		// turn off the electricity after the timer has expired
		if (zapTimer < 0)
		{
			zapTimer = 0;
			emitter.TurnOff();
		}
	}
}

function Destroyed()
{
	if (emitter != None)
	{
		emitter.Destroy();
		emitter = None;
	}

	Super.Destroyed();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();

	zapTimer = 0;
	emitter = Spawn(class'ElectricityEmitter', Self);
	if (emitter != None)
	{
		emitter.bFlicker = False;
		emitter.randomAngle = 1024;
		emitter.damageAmount = shockDamage;
		emitter.TurnOff();
		emitter.Instigator = Pawn(Owner);
	}
}

defaultproperties
{
     shockDamage=17
     ShotTime=0.900000
     HitDamage=28
     maxRange=1280
     AccurateRange=640
     BaseAccuracy=0.000000
	AmmoName=class'fgrhk.AmmoDXNGauss'
	ProjectileClass=class'fgrhk.DXNGaussWave'
     PickupAmmoCount=20
     bInstantHit=True
	FireSound=Sound'GaussGun.Weapons.GaussFire'
	PlayerViewOffset=(X=16.00,Y=-5.00,Z=-11.50)
}