//=============================================================================
// UCUIScalePOCJCDentonMale.
//=============================================================================
class UCUIScalePOCJCDentonMale extends JCDentonMale;

//
// -1: Relaxed (Scale with multiples of 640x450. Usefull for small 1440x900 screens).
//  0: Default (Stock behaviour to scale with multiples of 640x480.)
//  1: Maximum 1x
//  2: Maximum 2x
//  3: Maximum 3x (untested)
//  4: Maximum 4x (untested)
//  5: and so on...
//
var globalconfig int WindowScale;

// ----------------------------------------------------------------------------
// Spawned()
//
// Just to be able to check the logs to see whether an instance of this
// class was created.
// ----------------------------------------------------------------------------

simulated event Spawned()
{
	Super.Spawned();

	Log( "'ello :)" , 'UCUIScalePOC' );
}

// ----------------------------------------------------------------------------
// PreRender()
// ----------------------------------------------------------------------------

simulated event PreRender( Canvas Canvas )
{
	local float HardcodedWidth, HardcodedHeight;
	local float Width, Height;
	local float Multiplier;
	local float MouseX, MouseY;

	Super(PlayerPawn).PreRender( Canvas );

	if ( RootWindow!=None )
	{
		// Relaxed.
		if ( WindowScale<0 )
		{
			Multiplier = Max( 1.0, Min(Canvas.ClipX/640.0,Canvas.ClipY/450.0) );
		}
		else
		{
			// Calculate maximum possible multiplier.
			Multiplier = Max( 1.0, Min(Canvas.ClipX/640.0,Canvas.ClipY/480.0) );

			// Enforce a maximum multiplier if desired
			if ( WindowScale!=0 )
				Multiplier = Min( WindowScale, Multiplier );
		}

		// Save original window size.
		Width  = RootWindow.Width;
		Height = RootWindow.Height;

		// MouseX/MouseY will end up as -1, so set them aside.
		//MouseX = RootWindow.MouseX;
		//MouseY = RootWindow.MouseY;
		RootWindow.GetCursorPos( MouseX, MouseY );

		// Calcualte the values we need to HardcodedSize ahead, so we can override ClipX/ClipY.
		HardcodedWidth  = Canvas.ClipX/Multiplier;
		HardcodedHeight = Canvas.ClipY/Multiplier;

		// This will cause hMultiplier and vMultiplier to be set to Multiplier.
		// At the same time it will force HardcodedWidth and HardcodedHeight to be set to 640.0 and 480.0.
		Canvas.ClipX = Multiplier*640.0;
		Canvas.ClipY = Multiplier*480.0;

		// We need to set this to the same as HardcodedWidth and HardcodedHeight to prevent ResizeRoot
		// from calling ConfigureChild with that unintended size.
		RootWindow.Width  = 640.0;
		RootWindow.Height = 480.0;

		// Call the original routine.
		PreRenderWindows( Canvas );

		// Note that ClipX and ClipY got overriden, so neither
		// need nor do we want to touch those again.

		// Restore original sizes.
		RootWindow.Width  = Width;
		RootWindow.Height = Height;

		RootWindow.HardcodedWidth  = HardcodedWidth;
		RootWindow.HardcodedHeight = HardcodedHeight;

		if ( RootWindow.HardcodedWidth!=RootWindow.Width || RootWindow.HardcodedHeight!=RootWindow.Height )
			RootWindow.ConfigureChild( 0.0, 0.0, RootWindow.HardcodedWidth, RootWindow.HardcodedHeight );

		// Now restore and clamp mouse position.
		//RootWindow.MouseX = Clamp( MouseX, 0.0, RootWindow.Width -1.0 );
		//RootWindow.MouseY = Clamp( MouseY, 0.0, RootWindow.Height-1.0 );
		RootWindow.SetCursorPos( MouseX, MouseY ); // This may cause unintended mouse movement events.
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	WindowScale=1
}
