#!/bin/bash

if [ "$BASH_VERSION" = "" ] ; then
	echo "This is a Bash script. Please either start it normally (e.g.: \"./script.sh\"), or with Bash directly (e.g.: \"bash script.sh\")"
	exit 1
fi

if [ "$UID" == "0" ] && [ "$WINEWRAP_ALLOW_ROOT" != "1" ] ; then
	echo -e "You are trying to run this script as root - this is not recommended.\nTo avoid any undesirable results this script will abort.\nIf you want to run this as root anyway, set the environment variable WINEWRAP_ALLOW_ROOT=1"
	exit 1
fi

STARTWD="$PWD"
cd "$(dirname "$0")"
LOCALDIR="$PWD"

WRAP_NAME="Deus Ex: Revision"
WRAP_DIRNAME_DEF="Deus Ex GOTY"
WRAP_DIRNAME="$WRAP_DIRNAME_DEF"
WRAP_FILES=( "3d381fa014fb3f735d9d0949e215b6d23827b907f234479e29ade7ed464b2834"  "deusex_revision_res.tar.xz"
	"2da89f296fc06a20e721b8a2d065b2f7592397c2a7b18b89fb4e54438c3c5879"  "setup_deus_ex_revision_1.112fm(revision_1.6.1.0)_(45326)-1.bin"
"2eeeb098c64ec47b9e2ae1a26609b9d3bf3b9d30ec8e9accccece69fe1070c70"  "setup_deus_ex_revision_1.112fm(revision_1.6.1.0)_(45326).exe"
	)
INSTALLER_EXE=( "setup_deus_ex_revision_1.112fm(revision_1.6.1.0)_(45326).exe" )
MAKEARCHIVE=""
TEST=0

echo "$WRAP_NAME (Wine wrapper)"

while [ "$#" != "0" ] ; do
	ARGSTR=$(awk -F'=' '{print $1}' <<<"$1")
	case $ARGSTR in
		-xz)
			echo "Will build a .tar.xz archive"
			MAKEARCHIVE="xz"
			;;
		-gz)
			echo "Will build a .tar.gz archive"
			MAKEARCHIVE="gz"
			;;
		-test)
			if [ "$TEST" != "1" ] ; then
				echo "Test mode; will not attempt to build wrapper"
			fi
			TEST=1
			;;
		-buildpath)
			WINEWRAP_BUILDPATH="${1:11}"
			;;
		-respath)
			WINEWRAP_RESPATH="${1:9}"
			;;
		-dirname)
			WRAP_DIRNAME="${1:9}"
			;;
		-planb)
			echo "Plan B contingency for updated installers: Will run installer instead of extract."
			echo "WARNING: Wrappers created this way take a lot longer to create and may not work correctly!"
			WRAP_FILES=( "${WRAP_FILES[0]}" "${WRAP_FILES[1]}" )
			ALT_EXE="${1:7}"
			;;
		"")
			;;
		*)
			echo "Unrecognised argument: $1"
			exit 3
	esac
	shift
done

if [ ! -v WINEWRAP_BUILDPATH ] || [ "$WINEWRAP_BUILDPATH" == "" ] ; then
	WINEWRAP_BUILDPATH="$STARTWD"
elif [ "${WINEWRAP_BUILDPATH:0:1}" != "/" ] ; then
	WINEWRAP_BUILDPATH="$STARTWD/$WINEWRAP_BUILDPATH"
fi
WINEWRAP_BUILDPATH="$(realpath -m "$WINEWRAP_BUILDPATH")"
if [ "$?" != "0" ] ; then
	echo "ERROR: realpath returned non-zero exit status."
	exit 2
fi
TEMP="$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/temp"

CACHEDIR="${XDG_CACHE_HOME:-$HOME/.cache}"

INNOCMD=""
if [ "$WINEWRAP_USE_SYSTEM_INNOEXTRACT" == "1" ] ; then
	echo "Checking for innoextract..."
	if (innoextract --version >/dev/null) ; then
		if (( $(echo "$(innoextract --version | awk 'NR==1 {print $2}') >= 1.8" | bc -l) )) ; then
			echo "Using system provided innoextract"
			INNOCMD="innoextract"
		else
			echo "The system's version of innoextract is too old."
		fi
	else
		echo "System installed innoextract not found."
	fi
fi

if [ "$INNOCMD" == "" ] ; then
	if [ ! -e "$CACHEDIR/winewrap/innoextract/innoextract-1.9-linux.tar.xz" ] ; then
		echo "Attempting to download innoextract-1.9-linux.tar.xz"
		if (! wget "https://constexpr.org/innoextract/files/innoextract-1.9-linux.tar.xz" -P "$CACHEDIR/winewrap/innoextract") ; then
			echo "An error occurred downloading innoextract"
			rm "$CACHEDIR/winewrap/innoextract/innoextract-1.9-linux.tar.xz"
			ERROR=1
		fi
	else
		echo "Using previously downloaded innoextract-1.9-linux.tar.xz in $CACHEDIR/winewrap/innoextract"
	fi
	if (! sha256sum -c <<<"008efe5011476ccc4aae17c3e22038b5a1bc5c7aad2b9d4d869537bf3874d21f  $CACHEDIR/winewrap/innoextract/innoextract-1.9-linux.tar.xz") ; then
		echo "ERROR: Checksum failed for innoextract-1.9-linux.tar.xz !"
		rm "$CACHEDIR/winewrap/innoextract/innoextract-1.9-linux.tar.xz"
		ERROR=1
	else
		INNOARC="$CACHEDIR/winewrap/innoextract/innoextract-1.9-linux.tar.xz"
		INNOCMD="$TEMP/innoextract-1.9-linux/innoextract"
	fi
fi
echo "Checking for icoutils..."
if (! icotool --version >/dev/null) ; then
	echo "ERROR: attempt to invoke icotool failed; please make sure that the icoutils package (or your distro's equivalent) is installed"
	ERROR=1
fi
if (! wrestool --version >/dev/null) ; then
	echo "ERROR: attempt to invoke wrestool failed; please make sure that the icoutils package (or your distro's equivalent) is installed"
	ERROR=1
fi
if [ "$ERROR" == "1" ] ; then
	echo "One or more dependencies were not found."
	exit 5
fi

echo "Checking for installer and wrapper resource files..."

WRAP_FILES[1]="$LOCALDIR/${WRAP_FILES[1]}"

if [ "${WRAP_FILES[3]}" != "" ] ; then
	if [ -v WINEWRAP_RESPATH ] && [ "$WINEWRAP_RESPATH" != "" ] ; then
		if [ "${WINEWRAP_RESPATH:0:1}" != "/" ] ; then
			WINEWRAP_RESPATH="$STARTWD/$WINEWRAP_RESPATH"
		fi
		WINEWRAP_RESPATH="$(realpath -m "$WINEWRAP_RESPATH")"
		if [ ! -e "$WINEWRAP_RESPATH" ] ; then
			echo "WARNING: The specified resource path does not exist!"
			WINEWRAP_RESPATH=""
		elif [ ! -d "$WINEWRAP_RESPATH" ] ; then
			WINEWRAP_RESPATH="$(dirname "$WINEWRAP_RESPATH")"
		fi
	fi
	if [ ! -v WINEWRAP_RESPATH ] || [ "$WINEWRAP_RESPATH" == "" ] || [ ! -e "$WINEWRAP_RESPATH/${WRAP_FILES[3]}" ] ; then
		if [ -e "$STARTWD/${WRAP_FILES[3]}" ] ; then
			WINEWRAP_RESPATH="$STARTWD"
		elif [ -e "$WINEWRAP_BUILDPATH/${WRAP_FILES[3]}" ] ; then
			WINEWRAP_RESPATH="$WINEWRAP_BUILDPATH"
		else
			WINEWRAP_RESPATH="$LOCALDIR"
		fi
	fi
fi
if [ ! -f "${WRAP_FILES[1]}" ] ; then
	echo "Missing wrapper resource archive"
	ERROR=1
fi
FCOUNT=1
while [ "${WRAP_FILES[(($FCOUNT*2+1))]}" != "" ] ; do
	if [ ! -f "$WINEWRAP_RESPATH/${WRAP_FILES[(($FCOUNT*2+1))]}" ] ; then
		echo "Missing file: ${WRAP_FILES[(($FCOUNT*2+1))]}"
		ERROR=1
	fi
	WRAP_FILES[(($FCOUNT*2+1))]="$WINEWRAP_RESPATH/${WRAP_FILES[(($FCOUNT*2+1))]}"
	((FCOUNT++))
done

if [ "$ERROR" == "1" ] ; then
	echo -e "\nERROR: One or more required files are missing."
	exit 6
fi

echo "All files found."

if [ "$WINEWRAP_SKIP_CHECKSUMS" == "1" ] ; then
	echo "WARNING: skipping installer and resource archive checksum tests!"
else
	echo "Testing SHA256 hashes for installer and wrapper resource files..."
	for ((FNUM=0 ; FNUM < FCOUNT ; FNUM++)) ; do
		if (! sha256sum -c <<<"${WRAP_FILES[(($FNUM*2))]}  ${WRAP_FILES[(($FNUM*2+1))]}") ; then
			ERROR=1
		fi
	done
	if [ "$ERROR" == "1" ] ; then
		echo "ERROR: checksum failed on one or more files"
		exit 12
	fi
fi



if [ "$TEST" == "1" ] ; then
	echo "Test complete"
	exit
fi

if [ ${#WRAP_FILES[@]} -eq 2 ] ; then
	if [ "$ALT_EXE" == "" ] && ! ALT_EXE=$(zenity --file-selection --title="Please select the installer" --file-filter="setup*.exe | setup*.[eE][xX][eE]" --file-filter="All files | *") ; then
		exit
	fi
	echo "Selected installer: $ALT_EXE"
fi

if [ ! -e "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME" ] ; then
	if [ -f "$LOCALDIR/deusex_wine.sh" ] ; then
		echo "Deus Ex GOTY directory not present; attempting to build Wine wrapper..."
		"$LOCALDIR/deusex_wine.sh" -respath="$WINEWRAP_RESPATH" -buildpath="$WINEWRAP_BUILDPATH" -dirname="$WRAP_DIRNAME"
		DXW_RETCODE=$?
		if [ "$DXW_RETCODE" != "0" ] || [ ! -d "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME" ] || [ ! -f "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/start.sh" ] || [ ! -d "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/prefix/drive_c/$WRAP_DIRNAME_NEW" ] ; then
			echo "Failed to create wrapper for Deus Ex GOTY; cannot install Revision."
			if [ "$DXW_RETCODE" != "0" ] ; then
				exit "$DXW_RETCODE"
			else
				exit 5
			fi
		else
			echo "Installing Revision into the newly created Deus Ex GOTY wrapper..."
		fi
	else
		echo "ERROR: No existing Deus Ex GOTY wrapper or deusex_wine.sh present."
		exit 5
	fi
else
	if [ ! -f "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/start.sh" ] || [ ! -d "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/prefix/drive_c/$WRAP_DIRNAME_DEF" ] ; then
		echo "Existing Deus Ex wrapper appears to be incomplete; cannot install Revision."
		exit 5
	fi
	echo "Installing Revision into the existing Deus Ex GOTY wrapper"
fi

if [ -e "$TEMP" ] ; then
	echo "ERROR: temp directory exists already! The Deus Ex wrapper script may have encountered an error."
	exit 5
else
	mkdir -p "$TEMP"
fi

if [ "$INNOCMD" != "innoextract" ] ; then
	echo "Extracting innoextract..."
	tar -xf "$INNOARC" -C "$TEMP"
fi

export WINEVERPATH="$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/wine"
export PATH="$WINEVERPATH/bin:$PATH"
export LD_LIBRARY_PATH="$WINEVERPATH/lib:$WINEVERPATH/lib64:$LD_LIBRARY_PATH"
export WINE="$WINEVERPATH/bin/wine"
export WINELOADER="$WINEVERPATH/bin/wine"
export WINESERVER="$WINEVERPATH/bin/wineserver"
export WINEDLLPATH="$WINEVERPATH/lib/wine:$WINEVERPATH/lib64/wine"
export WINEPREFIX="$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/prefix"
export WINEDLLOVERRIDES=mscoree,mshtml,winemenubuilder.exe=d
export WINEDEBUG=-all

if [ ${#WRAP_FILES[@]} -gt 2 ] ; then
	echo "Extracting $WRAP_NAME..."
	if (! "$INNOCMD" "$WINEWRAP_RESPATH/${INSTALLER_EXE[0]}" -g -d "$TEMP/extract") ; then
		echo "ERROR: innoextract failed."
		exit 15
	fi
fi

if (! tar -xf "${WRAP_FILES[1]}" -C "$TEMP") ; then
	echo "An error occurred trying to unpack the wrapper resource archive."
	exit 16
fi

if [ -f "$WINEVERPATH/version" ] ; then
	WINEUSER="steamuser"
else
	WINEUSER="$USER"
fi

if [ ! -e "$WINEPREFIX/drive_c/users/$WINEUSER" ] ; then
	REMOVE_USERDIR=1
else
	REMOVE_USERDIR=0
fi

"$WINE" regedit "$TEMP/revision.reg"

if [ ${#WRAP_FILES[@]} -eq 2 ] ; then
	if [ "$REMOVE_USERDIR" == "1" ] ; then
		wineboot
		readarray -t PREFIX_SYMLINKS <<<$(find "$WINEPREFIX/drive_c/users/$WINEUSER" -maxdepth 1 -type l -printf "%f\n")
		for ((X=0 ; X < ${#PREFIX_SYMLINKS[@]} ; X++)) ; do
			rm "$WINEPREFIX/drive_c/users/$WINEUSER/${PREFIX_SYMLINKS[$X]}"
			mkdir "$WINEPREFIX/drive_c/users/$WINEUSER/${PREFIX_SYMLINKS[$X]}"
		done
	fi
	echo "Running the selected installer."
	echo "WARNING: Wrappers created this way take a lot longer to create and may not work correctly!"
	if ! "$WINE" "$ALT_EXE" /dir="C:\\$WRAP_DIRNAME_DEF" ; then
		echo "Installer reported failure. Aborting."
		exit 15
	fi
	if [ ! -e "$WINEPREFIX/drive_c/$WRAP_DIRNAME_DEF" ] ; then
		echo "Expected install path not found. Aborting."
		exit 15
	fi
	mkdir "$TEMP/app"
	mv "$WINEPREFIX/drive_c/$WRAP_DIRNAME_DEF/Revision" "$TEMP/app"
	mv "$WINEPREFIX/drive_c/$WRAP_DIRNAME_DEF/"goggame* "$TEMP/app"
fi

echo "Moving files into place..."
if [ ${#WRAP_FILES[@]} -eq 2 ] ; then
	mv "$TEMP/app/EULA"*.txt "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/docs"
else
	mv "$TEMP/extract/app" "$TEMP"
	mv "$TEMP/extract/Revision" "$TEMP/app"
	mv "$TEMP/extract/"*.* "$TEMP/app"
fi

mv "$TEMP/start-revision.sh" "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME"
mv "$TEMP/deusex_revision_rel_notes.txt" "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/docs"
mv "$TEMP/Revision.ini.1" "$WINEPREFIX/drive_c/$WRAP_DIRNAME_DEF/userdata-defaults"
mv "$TEMP/Revision.ini.3" "$WINEPREFIX/drive_c/$WRAP_DIRNAME_DEF/userdata-defaults"
mv "$TEMP/RevisionUser.ini" "$WINEPREFIX/drive_c/$WRAP_DIRNAME_DEF/userdata-defaults"
mv "$TEMP/goggame-1525634891.ico" "$TEMP/app"

icotool -x -i3 "$TEMP/app/goggame-1525634891.ico" -o "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/support/gog-deusex-revision-icon.png"
wrestool -x -t14 "$TEMP/app/Revision/System/Revision.exe" -o "$TEMP/revision.ico"
icotool -x -i6 "$TEMP/revision.ico" -o "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME/support/deusex-revision-icon.png"

mv "$TEMP/app/Revision" "$WINEPREFIX/drive_c/$WRAP_DIRNAME_DEF"
mv "$TEMP/app/"goggame* "$WINEPREFIX/drive_c/$WRAP_DIRNAME_DEF"

"$WINESERVER" -w

rm -rf "$TEMP"
if [ "$REMOVE_USERDIR" == "1" ] ; then
	rm -rf "$WINEPREFIX/drive_c/users/$WINEUSER"
fi

echo "Done."

if [ "$MAKEARCHIVE" == "xz" ] ; then
	echo "Building .tar.xz archive (this will take a while)"
	if (! tar -cf "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME-Revision-Linux.tar.xz" -C "$WINEWRAP_BUILDPATH" "$WRAP_DIRNAME" --xz) ; then
		echo "An error occurred building the tarball"
		exit 17
	fi
elif [ "$MAKEARCHIVE" == "gz" ] ; then
	echo "Building .tar.gz archive (this will take a while)"
	if (! tar -cf "$WINEWRAP_BUILDPATH/$WRAP_DIRNAME-Revision-Linux.tar.gz" -C "$WINEWRAP_BUILDPATH" "$WRAP_DIRNAME" --gz) ; then
		echo "An error occurred building the tarball"
		exit 17
	fi
fi
