#!/bin/bash

if [ "$BASH_VERSION" = "" ] ; then
	echo "This is a Bash script. Please either start it normally (e.g.: \"./script.sh\"), or with Bash directly (e.g.: \"bash script.sh\")"
	exit
fi

cd "$(dirname "$0")"
export LOCALDIR="$PWD"
source "$LOCALDIR/support/winewrap.shlib"

NAME="Deus Ex: Revision"
SFNAME_DEF="gog-deusex-revision.desktop"
if [ ! -v WINEWRAP_UDATA_ROOT ] || [ "$WINEWRAP_UDATA_ROOT" == "" ] ; then
	WINEWRAP_UDATA_ROOT="${XDG_DATA_HOME:-$HOME/.local/share}"
fi
UDATAPATH="$WINEWRAP_UDATA_ROOT/deusex"
LDATAPATH="$LOCALDIR/userdata"
ICON_DEFAULT="gog-deusex-revision-icon.png"
ICON="$LOCALDIR/support/$ICON_DEFAULT"
STARTOPT=""
DTNAME="DeusExRevision"
DEFWD="$LOCALDIR/prefix/drive_c/Deus Ex GOTY/Revision/System"
USEWD=""
STARTCMD="Revision.exe"
SCCATS_DEF="Game;RolePlaying;"
SCARGS_DEF="play"
SCNAME=""
SCPATH=""
SFNAME=""
SCARGS=""
SCCATS=""

if [ -f "$LOCALDIR/wine/bin/wine" ] ; then
	setup_wineenv "$LOCALDIR/wine"
elif [ -f "$LOCALDIR/wine/dist/bin/wine" ] ; then
	setup_wineenv "$LOCALDIR/wine/dist"
else
	echo "ERROR: Wine not found!"
	exit 127
fi
export PATH="$WINEVERPATH/bin:$PATH"
export WINEPREFIX="$LOCALDIR/prefix"
export WINETRICKS="$LOCALDIR/support/winetricks"
if [ ! -v WINEDEBUG ] ; then
	export WINEDEBUG=-all
fi
if [ ! -v DXVK_LOG_LEVEL ] ; then
	export DXVK_LOG_LEVEL=none
fi

while [ "$#" != "0" ] ; do
	ARGSTR=$(awk -F'=' '{print $1}' <<<"$1")
	case $ARGSTR in
		:)
			shift
			break
			;;
		menu|kill|play|run|runwine|shortcut|-s)
			if [ "$STARTOPT" != "" ] ; then
				echo "ERROR: Multiple start options specified"
				exit
			fi
			STARTOPT="$ARGSTR"
			if [ "$ARGSTR" == "runwine" ] ; then
				STARTCMD="${1:8}"
			elif [ "$ARGSTR" == "run" ] ; then
				STARTCMD="${1:4}"
			fi
			;;
		cd)
			USEWD="${1:3}"
			winpath_to_prefix USEWD
			;;
		desktop)
			WRAP_DT_RES="${1:8}"
			;;
		icon)
			ICON=$(awk '{$1=$1};1' <<<"${1:5}")
			if [ "${ICON:0:1}" != "/" ] ; then
				ICON="$LOCALDIR/support/$ICON"
			fi
			if [ ! -f "$ICON" ] ; then
				echo "Icon missing or not specified."
				ICON="$LOCALDIR/support/$ICON_DEFAULT"
			fi
			;;
		scl)
			SCPATH="${1:4}"
			;;
		scn)
			SCNAME=$(awk '{$1=$1};1' <<<"${1:4}")
			if [ "$SCNAME" == "" ] ; then
				echo "Shortcut name cannot be blank!"
				exit
			fi
			;;
		sfn)
			SFNAME=$(awk '{$1=$1};1' <<<"${1:4}")
			if [ "$SFNAME" == "" ] ; then
				echo "Shortcut filename cannot be blank!"
				exit
			fi
			if [ "${SFNAME: -8}" != ".desktop" ] ; then
				SFNAME="$SFNAME.desktop"
			fi
			;;
		sca)
			SCARGS="${1:4}"
			;;
		scc)
			SCCATS="${1:4}"
			;;
		checkres)
			if [ "${1:9}" == "0" ] ; then
				echo "Post-run resolution check disabled"
				WRAP_CHECK_RES=0
			else
				echo "Post-run resolution check enabled"
				WRAP_CHECK_RES=1
			fi
			;;
		resetgamma)
			if [ "${1:11}" == "0" ] ; then
				echo "Post-run gamma reset disabled"
				WRAP_RESET_GAMMA=0
			else
				echo "Post-run gamma reset enabled"
				WRAP_RESET_GAMMA=1
			fi
			;;
		"")
			;;
		*)
			echo "Unrecognised argument: $1"
			exit
	esac
	shift
done

if [ "$STARTOPT" == "kill" ] ; then
	"$WINESERVER" -k
	exit
fi

get_desktop_res
if [ "$?" != 0 ] ; then
	exit
fi
get_display_gamma

if [ -f "$LOCALDIR/support/desktop" ] && [ ! -v WRAP_DT_RES ] ; then
	WRAP_DT_RES=$(head -n1 "$LOCALDIR/support/desktop" | awk '{print $1}')
fi

if [ -v WRAP_DT_RES ] ; then
	if [ "${WRAP_DT_RES:0:1}" == "0" ] ; then
		WRAP_DT_RES=""
	elif [[ ! "$WRAP_DT_RES" =~ ^[[:digit:]]{3,}[xX][[:digit:]]{3,}$ ]] ; then
		WRAP_DT_RES="$CURRENT_RES"
	fi
fi

# Check userdata

init_prefix nolinks

if [ -d "$LDATAPATH" ] && [ ! -L "$LDATAPATH" ] ; then
	echo "Using local userdata directory"
	UDATAPATH="$LDATAPATH"
	UDATA_LTYPE="relative"
else
	if [ -L "$LDATAPATH" ] && [ -d "$LDATAPATH" ] ; then
		UDATAPATH="$(realpath "$LDATAPATH")"
	fi
	echo "Userdata directory: $UDATAPATH"
	UDATA_LTYPE=""
fi

link_to_userdata "C:\\Deus Ex GOTY\\Revision\\System\\Revision.ini" "Revision/Revision.ini" "Revision.ini" "file" "$UDATA_LTYPE"
link_to_userdata "C:\\Deus Ex GOTY\\Revision\\System\\RevisionUser.ini" "Revision/RevisionUser.ini" "RevisionUser.ini" "file" "$UDATA_LTYPE"
link_to_userdata "C:\\Deus Ex GOTY\\Revision\\Save" "Revision/Save" "Save directory" "directory" "$UDATA_LTYPE"

if [ ! -e "$WINEPREFIX/drive_c/Deus Ex GOTY/Revision/System/Revision.ini" ] ; then
	echo "Copying default Revision.ini..."
	cat "$WINEPREFIX/drive_c/Deus Ex GOTY/userdata-defaults/Revision.ini.1" - "$WINEPREFIX/drive_c/Deus Ex GOTY/userdata-defaults/Revision.ini.3" >"$WINEPREFIX/drive_c/Deus Ex GOTY/Revision/System/Revision.ini" << EOF
FullscreenViewportX=$CURRENT_RES_X
FullscreenViewportY=$CURRENT_RES_Y
EOF
fi

if [ ! -e "$WINEPREFIX/drive_c/Deus Ex GOTY/Revision/System/RevisionUser.ini" ] ; then
	echo "Copying default RevisionUser.ini..."
	cat "$WINEPREFIX/drive_c/Deus Ex GOTY/userdata-defaults/RevisionUser.ini" >"$WINEPREFIX/drive_c/Deus Ex GOTY/Revision/System/RevisionUser.ini"
fi



run_game()
{
	cd "$DEFWD"
	run_wine : cpuaffinity=0x1 : "$STARTCMD" "$@"
}

show_menu()
{
	if MENUSTR=$(zenity --list --hide-header --title="$NAME" --window-icon="$ICON" --width=300 --height=175 --text="${NAME//&/&amp;}" --column="Launch options:" \
		"Play" \
		"Create shortcut..." \
		"Advanced options..." ) ; then
		case $MENUSTR in
			"Play")
				run_game "$@"
				;;
			"Create shortcut...")
				create_sc_gui
				;;
			"Advanced options...")
				winewrap_menu
				;;
		esac
	fi
}


case $STARTOPT in
	menu)
		show_menu "$@"
		;;
	shortcut|-s)
		if [ "$SCPATH" == "" ] ; then
			create_sc_gui
		else
			create_shortcut "$SCNAME" "$SCPATH" "$SFNAME" "$SCARGS" "$SCCATS" "$ICON"
		fi
		;;
	play)
		run_game "$@"
		;;
	run)
		cd "$USEWD"
		$STARTCMD "$@"
		;;
	runwine)
		cd "$DEFWD"
		cd "$USEWD"
		if [ "$STARTCMD" != "" ] ; then
			run_wine "$STARTCMD" "$@"
		elif [ "$1" != "" ] ; then
			run_wine "$@"
		else
			run_wine_gui
		fi
		;;
	"")
		show_menu "$@"
		;;
	*)
		echo "Unrecognised start option: $STARTOPT"
esac
