class OPIOFile extends Object;

var OPIO IOInstance;
var string FileName;

/**
 * Write text to file. If file does not exists, new is created. If file exists, it's content is erased first.
 *
 * @param text      Text to write to file.
 * @return Returns true if write was successful, otherwise false.
 */
final function bool WriteText(string text)
{
	return IOInstance.WriteText(FileName, text);
}

/**
 * Append text to file. If file does not exists, new is created. If file exists, it's content is not erased, provided text is appended to the end of the file.
 *
 * @param text      Text to write to file.
 * @return Returns true if write was successful, otherwise false.
 */
final function bool AppendText(string text)
{
	return IOInstance.AppendText(FileName, text);
}

/**
 * Append endline characters to the end of the file.
 *
 * @return Returns true if write was successful, otherwise false.
 */
final function bool AppendEndLine()
{
	return IOInstance.AppendEndLine(FileName);
}

/**
 * Append text lines to the file.
 *
 * @param lines     Array of text lines.
 * @return Returns true if write was successful, otherwise false.
 */
final function bool AppendLines(array<string> lines)
{
	return IOInstance.AppendLines(FileName, lines);
}

/**
 * Write text lines to the file.
 *
 * @param lines     Array of text lines.
 * @return Returns true if write was successful, otherwise false.
 */
final function bool WriteLines(array<string> lines)
{
	return IOInstance.WriteLines(FileName, lines);
}

/**
 * Read all text from file.
 *
 * @param text      Out string parameter where to save read text to.
 * @return Returns true if read was successful, otherwise false.
 */
final function bool ReadText(out string text)
{
	return IOInstance.ReadText(FileName, text);
}

/**
 * Read all text lines from file.
 *
 * @param lines      Out array of strings where read lines are saved to.
 * @return Returns true if read was successful, otherwise false.
 */
final function bool ReadLines(out array<string> lines)
{
	return IOInstance.ReadLines(FileName, lines);
}

DefaultProperties
{
}
