/** DO NOT USE THIS CLASS DIRECTLY, USE OPNetUDPServer and OPNetUDPClient instead */
class OPNetUDP extends Object DLLBind(OPNetUDP);

var int UDPSocket;

var InternetLink Owner;

dllimport final function int _BindSocket(int p);
dllimport final function _CloseSocket(int s);
dllimport final function _SendString(int s, string str, int ip, int p);
dllimport final function string _RecvString(int s, out int res, out int ip, out int p);

final function SendTextTo(string text, IpAddr ra)
{
	if (UDPSocket <= 0) return;

	_SendString(UDPSocket, text, ra.Addr, ra.Port);
}

final function int ReadTextFrom(out string s, out IpAddr ra)
{
	local string str;
	local int res;

	str = _RecvString(UDPSocket, res, ra.Addr, ra.Port);
	
	if (res == -1) return 0;

	s = str;
	return res;
}


event ReceivedTextFrom(string text, IpAddr ra);

event Tick(float DeltaTime)
{
	local string str;
	local int res;
	local IpAddr addr;

	if (UDPSocket > 0 && Owner.ReceiveMode == RMODE_Event)
	{
		str = _RecvString(UDPSocket, res, addr.Addr, addr.Port);
		while (res != -1)
		{
			if (OPNetUDPClient(Owner) != none)
				OPNetUDPClient(Owner).ReceivedTextFrom(str, addr);
			else if (OPNetUDPServer(Owner) != none)
				OPNetUDPServer(Owner).ReceivedTextFrom(str, addr);
			str = _RecvString(UDPSocket, res, addr.Addr, addr.Port);
		}
	}
}

DefaultProperties
{
}
