class OPNetUDPClient extends InternetLink;

var private OPNetUDP UDPObj;

/** Remote address this UDP object is communicating with. */
var IpAddr RemoteAddr;

/**
 * Initialize UDP client object; create socket.
 *
 * @param remote        Remote address where UDP packets are sent to.
 * @return Returns true if socket creation was successful.
 */
final function bool Initialize(IpAddr remote)
{
	UDPObj = new class'OPNetUDP';
	UDPObj.Owner = self;

	RemoteAddr = remote;
	UDPObj.UDPSocket = UDPObj._BindSocket(0);

	if (UDPObj.UDPSocket > 0) return true;
	else return false;
}

/**
 * Send text.
 *
 * @param text        Text to send.
 */
final function SendText(string text)
{
	UDPObj.SendTextTo(text, RemoteAddr);
}

/**
 * Read text from received UDP packet.
 *
 * @param s        Out string where text is saved to.
 * @return Returns number of characters written in s. Returns 0 if no data was received.
 */
final function int ReadText(out string s)
{
	local IpAddr addr;
	local int res;

	res = UDPObj.ReadTextFrom(s, addr);
	if (res == -1) return 0;
	if (addr.Addr != RemoteAddr.Addr || addr.Port != RemoteAddr.Port) return 0;

	return res;
}

/**
 * Override this event to receive UDP text. If ReceiveMode is RMODE_Event, this event is called when data is available.
 *
 * @param text        Text received via UDP.
 */
event ReceivedText(string text);


/** PRIVATE FUNCTIONS */

event ReceivedTextFrom(string text, IpAddr ra)
{
	if (ra.Addr == RemoteAddr.Addr && ra.Port == RemoteAddr.Port)
		ReceivedText(text);
}

event Tick(float DeltaTime)
{
	if (UDPObj != none)
		UDPObj.Tick(DeltaTime);
}

event Destroyed()
{
	if (UDPObj != none && UDPObj.UDPSocket > 0)
		UDPObj._CloseSocket(UDPObj.UDPSocket);
}

DefaultProperties
{
}
