class OPNetUDPServer extends InternetLink;

var private OPNetUDP UDPObj;

/**
 * Initialize UDP server object; create socket and bind local port.
 *
 * @param localport     Local port to bind.
 * @return Returns true if socket creation was successful. If false is returned, local port might be in use.
 */
final function bool Initialize(int localport)
{
	UDPObj = new class'OPNetUDP';
	UDPObj.Owner = self;

	UDPObj.UDPSocket = UDPObj._BindSocket(localport);

	if (UDPObj.UDPSocket > 0) return true;
	else return false;
}

/**
 * Send text.
 *
 * @param text        Text to send.
 * @param ra          Remote address to send to.
 */
final function SendTextTo(string text, IpAddr ra)
{
	UDPObj.SendTextTo(text, ra);
}

/**
 * Read text from received UDP packet.
 *
 * @param s        Out string where text is saved to.
 * @param ra       Remote address where text was received from.
 * @return Returns number of characters written in s. Returns 0 if no data was received.
 */
final function int ReadTextFrom(out string s, out IpAddr ra)
{
	return UDPObj.ReadTextFrom(s, ra);
}

/**
 * Override this event to receive UDP text. If ReceiveMode is RMODE_Event, this event is called when data is available.
 *
 * @param text        Text received via UDP.
 * @param ra          Remote address where text was received from.
 */
event ReceivedTextFrom(string text, IpAddr ra);


/** PRIVATE FUNCTIONS */

event Tick(float DeltaTime)
{
	if (UDPObj != none)
		UDPObj.Tick(DeltaTime);
}

event Destroyed()
{
	if (UDPObj != none && UDPObj.UDPSocket > 0)
		UDPObj._CloseSocket(UDPObj.UDPSocket);
}

DefaultProperties
{
}
